<?php
// Funkcja wykrywajca cieki bezwzgldne.
function is_absolute($path) {
    // Sprawdzenie, czy cieka rozpoczyna si od znaku '/'. Jeli tak, to jest to cieka bezwzgldna.
    if ($path{0} == '/') {
        return true;
    } else {
        return false;
    }
}

// Funkcja wykrywajca bezwzgldne adresy URL.
function is_absoluteurl($path) {
    // Sprawdzenie, czy cieka rozpoczyna si od waciwej specyfikacji protokou.
    if (preg_match('|^[a-zA-Z]+://|', $path)) {
        return true;
    } else {
        return false;
    }
}

// Funkcja wykrywajca cieki wzgldne.
function is_relative($path) {
    // Poniewa nie jest to adna z odmian cieki bezwzgldnej,
    // musi to by cieka wzgldna.
    if ( !(is_absolute($path)) && !(is_absoluteurl($path)) ) {
        return true;
    } else {
        return false;
    }
}

// Funkcja, ktra na podstawie cieki w dowolnej postaci przeksztaca j na
// bezwzgldny adres URL i zwraca j.
function ensure_absoluteurl($path) {
    // Jeli jest to bezwzgldny adres URL, zwrcenie go.
    if (is_absoluteurl($path)) {
        return $path;
    }
    // Jeli jest to cieka bezwzgldna, dodanie do niej cigu http i nazwy hosta.
    elseif (is_absolute($path)) {
        return "http://{$_SERVER['HTTP_HOST']}{$path}";
    }
    // cieka jest wzgldna, zatem trzeba utworzy cay cig.
    else {
        return 'http://' . $_SERVER['HTTP_HOST'] .
            dirname($_SERVER['PHP_SELF']) . '/' . $path;
    }
}

// Kilka przykadw.
$tests = array('http://eliw.com/docs/book/php5/01.php',
    '/docs/book/php5/01.php', 'php5/01.php', '../book/php5/01.php');

// Uruchomienie odpowiednich funkcji dla poszczeglnych przypadkw.
foreach ($tests as $tc) {
    echo "<p>\n";
    echo "Czy cieka {$tc} jest wzgldna? ", is_relative($tc) ? 'Tak' : 'Nie', 
         "<br>\n";
    echo "Czy cieka {$tc} jest bezwzgldna? ", is_absolute($tc) ? 'Tak' : 'Nie', 
          "<br>\n";
    echo "Czy adres URL {$tc} jest bezwzgldny? ",
        is_absoluteurl($tc) ? 'Tak' : 'Nie', "<br>\n";
    echo "Po przeksztaceniu na bezwzgldny adres URL otrzymujemy: ", is_absolute($tc) ;
    echo "</p>\n";
}
?>
