<?php
// Funkcja, ktra przeglda drzewo katalogw w poszukiwaniu plikw pasujcych
// do podanego wyraenia regularnego i zwraca wszystkie pliki speniajce okrelone kryteria.
function find($regex, $dir) {
    $matches = array();

    // Otwarcie katalogu i przygotowanie do rozpoczcia ptli.
    $d = dir($dir);

    // Przetwarzanie w ptli wszystkich plikw.
    while (false !== ($file = $d->read())) {
        // Pominicie plikw . i ..  nie chcemy si nimi zajmowa.
        if (($file == '.') || ($file == '..')) { continue; }

        // Jeli to jest katalog:
        if (is_dir("{$dir}/{$file}")) {
            // Rekurencyjne wywoanie funkcji w celu przeprowadzenia wyszukiwania w podkatalogu.
            $submatches = find($regex, "{$dir}/{$file}");
            // Dodanie pliku do biecej listy wynikw.
            $matches = array_merge($matches, $submatches);
        } else {
            // Bieca pozycja to plik  sprawdzenie, czy spenia kryteria.
            if (preg_match($regex, $file)) {
                // Dodanie pliku do tablicy.
                $matches[] = "{$dir}/{$file}";
            }
        }
    }

    // Zwrcenie tablicy wynikw.
    return $matches;
}

// Wyszukiwanie wszystkich skryptw PHP w witrynie WWW, poczwszy od gwnego katalogu dokumentw.
$found = find('/\.php$/', $_SERVER['DOCUMENT_ROOT']);

// Sortowanie plikw i wywietlenie.
sort($found);
echo '<pre>', print_r($newarray, true), '</pre>';
?>
