<?php
// Odczytanie wszystkich parametrw i sprawdzenie, czy s prawidowe.
if (!(isset($argc))) {
    // Prba uruchomienia skryptu z internetu.
    echo "Ten skrypt mona uruchamia tylko z poziomu wiersza polecenia!";
    exit();
}

// Sprawdzenie, czy podano co najmniej 2 i co najwyej 3 parametry.
// Naley pamita, e nazwa pliku to argument $argv[0], ktry liczy si jako jeden.
if (($argc < 3) || ($argc > 4)) {
    // Prba nieprawidowego uycia, wywietlenie komunikatu o bdzie i wyjcie.
    echo "
Nieprawidowe uycie! Prosz uy nastpujcej skadni:
 {$argv[0]} <wyraenie_regularne_opisujce_nazw_pliku> <nowa_nazwa> [katalog]
";
    exit();
}

// Jeli skrypt doszed do tego miejsca, wywoano go z prawidow liczb parametrw.
// Zapisanie danych w zmiennych o waciwych nazwach.
$old = $argv[1];
$new = $argv[2];
// Pobranie nazwy katalogu. Jeli jej nie podano, domylnie przyjmuje si nazw biecego katalogu.
$dir = isset($argv[3]) ? $argv[3] : '.';

// Sprawdzenie, czy katalog istnieje; jeli nie istnieje  zakoczenie dziaania skryptu.
if (!(is_dir($dir))) {
    echo "Bd: Katalog {$dir} nie istnieje!\n";
    exit();
}

// Usunicie znakw '/' lub '\', jeli nazwa katalogu koczy si
// jednym z nich.
$dir_noslash = preg_replace('|([/\\\])$|', '', $dir);

// Teraz mona rozpocz przeksztacanie nazw plikw. Otwarcie katalogu.
$d = dir($dir);

// Przetwarzanie w ptli wszystkich plikw.
while (false !== ($file = $d->read())) {
    // Pominicie plikw . i ..  nie chcemy zmienia im nazwy.
    if (($file == '.') || ($file == '..')) { continue; }

    // Wykonanie podanych przeksztace nazwy pliku.
    $newname = preg_replace($old, $new, $file);

    // Obsuga nieprawidowych wyrae regularnych.
    if (!(isset($newname))) {
        echo "Bd: Wystpi problem z podanym wyraeniem regularnym\n";
        exit();
    }

    // Zmiana nazwy pliku.
    if ($newname != $file) {
        rename("{$dir_noslash}/{$file}", "{$dir_noslash}/{$newname}");
    }
}
?>
