<?php
// Funkcja wywietlajca liczb bajtw w pliku w postaci cigu znakw sformatowanego w naturalny sposb.
// W tej wersji zaoono e kilobajt ma 1024 bajty.
function format_bytes($bytes) {
    // Definicja tablicy zawierajcej rne jednostki.
    // Zatwierdzone binarne odpowiedniki jednostek zgodnie z ukadem SI.
    $display = array('B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB',
        'ZiB', 'YiB');

    // Dzielenie wartoci w bajtach przez 1024 do czasu uzyskania wartoci mniejszej ni 1024.
    $level = 0;
    while ($bytes > 1024) {
        $bytes /= 1024;
        $level++;
    }

    // Po obliczeniu ostatecznej wartoci formatujemy j do 1 miejsca po przecinku
    // i doczamy odpowiedni symbol jednostki.
    return round($bytes, 1) . ' ' . $display[$level];
}

// Wywietlenie kilku przykadw w celu przetestowania funkcji:
echo '<p>4200 bajtw = ', format_bytes(4200), "<p>\n"; // 4.1 KiB
echo '<p>420000 bajtw = ', format_bytes(420000), "<p>\n"; // 410.2 KiB
echo '<p>42000000 bajtw = ', format_bytes(42000000), "<p>\n"; // 40.1 MiB
?>
