<?php
// Ten skrypt doskonale peni funkcj pliku index.php w katalogu, w ktrym
// chcemy wywietli wszystkie pliki. Automatycznie wyklucza sam siebie z listy.
//  Z atwoci mona go zmodyfikowa, by wykluczy take inne pliki.

// Zdefiniowanie tablicy zawierajcej pliki.
$files = array();

// Otwarcie biecego katalogu.
$d = dir('.');

// Przetwarzanie w ptli wszystkich plikw.
while (false !== ($file = $d->read())) {
    // Jeli biecy plik nie jest tym, ktry zawiera ten kod, nie rozpoczyna si od '.' bd '~'
    // i nie koczy si na LCK, zapianie go w celu pniejszego wywietlenia.
    if ( ($file{0} != '.') &&
         ($file{0} != '~') &&
         (substr($file, -3) != 'LCK') &&
         ($file != basename($_SERVER['PHP_SELF']))    ) {
        // Zapisanie nazwy pliku i penych danych na jego temat z wykorzystaniem funkcji stat().
        $files[$file] = stat($file);
    }
}

// Zamknicie katalogu.
$d->close();

// Wywietlenie prostej tabeli zawierajcej odczytane informacje.
echo '<style>td { padding-right: 10px; }</style>';
echo '<table><caption>Zawarto tego katalogu:</caption>';

// Sortowanie plikw w porzdku alfabetycznym.
ksort($files);

// Prygotowanie do wykorzystania funkcji obsugi dat:
date_default_timezone_set('Europe/Warsaw');

// Przegldanie tablicy plikw w ptli i wywietlanie kolejnych wierszy tabeli.
foreach ($files as $name => $stats) {
    // Pocztek wiersza i wywietlenie cza z wykorzystaniem nazwy pliku.
    echo "<tr><td><a href=\"{$name}\">{$name}</a></td>\n";
    // Wywietlenie komrki zawierajcej rozmiar pliku w bajtach.
    echo "<td align='right'>{$stats['size']}</td>\n";
    // Kolumna zawierajca dat.
    echo '<td>', date('m-d-Y h:ia', $stats['mtime']), "</td></tr>\n";
}

echo '</table>';
?>
