<?php
// Definicja klasy implementujcej samosortujce si drzewo binarne.
class Sorting_Tree {
    // Zdefiniowanie zmiennej dla drzewa.
    public $tree;

    // Potrzebna jest metoda umoliwiajca wstawianie elementu w lokalizacji
    // automatycznie uwzgldniajcej waciwy porzdek drzewa.
    public function insert($val) {
        // Obsuga pierwszego przypadku.
        if (!(isset($this->tree))) {
            $this->tree = new Binary_Tree_Node($val);
        } else {
            // Wszystkie pozostae przypadki.
            // Zainicjowanie wskanika, ktry wskazuje wierzchoek biecego drzewa.
            $pointer = $this->tree;
            // Iteracyjne przeszukiwanie drzewa w celu znalezienia waciwej lokalizacji.
            for(;;) {
                // Jeli warto jest mniejsza lub rwna biecemu elementowi danych:
                if ($val <= $pointer->data) {
                    // Szukamy danych po lewej stronie.  Jeli istnieje wze  potomny:
                    if ($pointer->left) {
                        // Przegldanie w gb.
                        $pointer = $pointer->left;
                    } else {
                        // Znaleziono waciwe miejsce: wstawienie nowego elementu.
                        $pointer->left = new Binary_Tree_Node($val);
                        break;
                    }
                } else {
                    // Szukamy danych po prawej stronie. Jeli istnieje wze  potomny:
                    if ($pointer->right) {
                        // Przegldanie w gb.
                        $pointer = $pointer->right;
                    } else {
                        // Znaleziono waciwe miejsce: wstawienie nowego elementu.
                        $pointer->right = new Binary_Tree_Node($val);
                        break;
                    }
                }
            }
        }
    }

    // Utworzenie metody zwracajcej posortowane elementy drzewa,
    // wykorzystujcej tryb in-order. Dziki temu
    // uzyskamy posortowan list.
    public function returnSorted() {
        return $this->tree->traverseInorder();
    }
}

// Zadeklarowanie nowego samosortujcego si drzewa.
$sort_as_you_go = new Sorting_Tree();

// Losowe wygenerowanie 20 liczb i wstawianie ich do struktury na bieco.
for ($i = 0; $i < 20; $i++) {
    $sort_as_you_go->insert(rand(1,100));
}

// Wywietlenie drzewa z wykorzystaniem trybu in-order. Uzyskamy posortowany cig.
// Przykad: 1, 2, 11, 18, 22, 26, 32, 32, 34, 43, 46, 47, 47, 53, 60, 71,
//   75, 84, 86, 90.
echo '<p>', implode(', ', $sort_as_you_go->returnSorted()), '</p>';
?>
