<?php
// Definicja klasy implementujcej drzewo binarne.
class Binary_Tree_Node {
    // Zdefiniowanie zmiennej przeznaczonej na dane.
    public $data;
    // Dodanie zmiennych, ktre posu do zapisania referencji do prawego i lewego obiektu.
    public $left;
    public $right;

    // Konstruktor umoliwiajcy przekazywanie danych.
    public function __construct($d = NULL) {
        $this->data = $d;
    }

    // Przegldanie drzewa, od lewej do prawej, w trybie pre-order, zwrcenie tablicy obiektw.
    // Tryb pre-order oznacza, e warto wza poprzedza wszystkie jego wzy potomne.
    public function traversePreorder() {
        // Przygotowanie kilku zmiennych.
        $l = array();
        $r = array();

        // Odczytanie lewego i prawego wza potomnego z zachowaniem odpowiedniej reguy przegldania.
        if ($this->left) { $l = $this->left->traversePreorder(); }
        if ($this->right) { $r = $this->right->traversePreorder(); }

        // Zwrcenie tablicy skadajcej si z elementu biecego oraz lewego i prawego.
        return array_merge(array($this->data), $l, $r);
    }

    // Przegldanie drzewa, od lewej do prawej, w trybie post-order, zwrcenie tablicy obiektw.
    // Tryb post-order oznacza, e warto wza wystpuje za jego wzami potomnymi.
    public function traversePostorder() {
        // Przygotowanie kilku zmiennych.
        $l = array();
        $r = array();

        // Odczytanie lewego i prawego wza potomnego z zachowaniem odpowiedniej reguy przegldania.
        if ($this->left) { $l = $this->left->traversePostorder(); }
        if ($this->right) { $r = $this->right->traversePostorder(); }

        // Zwrcenie tablicy skadajcej si z elementu biecego oraz lewego i prawego.
        return array_merge($l, $r, array($this->data));
    }

    // Przegldanie drzewa, od lewej do prawej, w trybie in--order, zwrcenie tablicy obiektw.
    // In-order oznacza, e elementy wystpuj w nastpujcym porzdku: lewe wzy potomne,
    //  warto wza, prawe wzy potomne.
    public function traverseInorder() {
        // Przygotowanie kilku zmiennych.
        $l = array();
        $r = array();

        // Odczytanie lewego i prawego wza potomnego z zachowaniem odpowiedniej reguy przegldania.
        if ($this->left) { $l = $this->left->traverseInorder(); }
        if ($this->right) { $r = $this->right->traverseInorder(); }

        // Zwrcenie tablicy skadajcej si z elementu biecego oraz lewego i prawego.
        return array_merge($l, array($this->data), $r);
    }
}

// Utworzenie drzewa binarnego o nastpujcej zawartoci   :    3
//                                                             / \
//                                                            h   9
//                                                               / \
// Utworzenie drzewa:                                           6   a
$tree = new Binary_Tree_Node(3);
$tree->left = new Binary_Tree_Node('h');
$tree->right = new Binary_Tree_Node(9);
$tree->right->left = new Binary_Tree_Node(6);
$tree->right->right = new Binary_Tree_Node('a');

// Przegldanie drzewa we wszystkich dostpnych trybach i wywietlenie wynikw.

// Pre-order: 3, h, 9, 6, a
echo '<p>', implode(', ', $tree->traversePreorder()), '</p>';

// Post-order: h, 9, 6, a, 3
echo '<p>', implode(', ', $tree->traversePostorder()), '</p>';

// In-order: h, 3, 6, 9, a
echo '<p>', implode(', ', $tree->traverseInorder()), '</p>';
?>
