<?php
// Zdefiniowanie klasy w celu zaimplementowania powizanych list  wze listy.
class Linked_List_Node {
    // Zdefiniowanie zmiennej, ktra bdzie zawiera dane.
    public $data;
    // Dodanie zmiennej, ktra bdzie zawiera informacje o nastpnym obiekcie w acuchu.
    public $next;

    // Konstruktor umoliwiajcy przekazywanie danych.
    public function __construct($d = NULL) {
        $this->data = $d;
    }

    // Utworzenie kilku metod, ktre nieco zautomatyzuj obsug list.

    // Najpierw zdefiniujemy metod wstawiajc wze za wzem biecym.
    public function insertAfter(Linked_List_Node $insert) {
        // Zakadamy przekazanie pojedynczego wza, a nie caej listy.
        // W przypadku przekazania wza z listy pozostaa jej cz zostanie utracona.

        // Ustawienie wskanika na nastpny obiekt w nowym wle na warto wza biecego.
        $insert->next = $this->next;

        // Ustawienie wskanika na nastpny obiekt w biecym wle na warto nowego wza.
        $this->next = $insert;
    }

    // Metoda, ktra usuwa wze za wzem biecym.
    public function removeAfter() {
        // Zapisanie referencji do wza, ktry ma by usunity.
        $ref = $this->next;

        // Pominicie wza poprzez dowizanie do jego wza potomnego (jeli istnieje).
        if (isset($this->next->next)) {
            $this->next = $this->next->next;
        } else {
            // W innym przypadku ustawienie go na warto null.
            $this->next = NULL;
        }

        // Zniszczenie obiektu.
        unset($ref);
    }

    // Zdefiniowanie metody, ktra wywietli ca zawarto powizanej listy,
    // poczwszy od biecego wza.
    public function asString() {
        // Jeli istnieje kolejny wze potomny, odczytanie jego wartoci.
        $children = '';
        if ($this->next) {
            $children = ', ' . $this->next->asString();
        }

        // Zwrcenie danych powizanych z danymi wszystkich wzw potomnych.
        return $this->data . $children;
    }
}

// Utworzenie nowej powizanej listy.
$list = new Linked_List_Node('PHP');

// Dodanie elementu za biecym.
$list->insertAfter(new Linked_List_Node('Perl'));

// Wstawienie elementu pomidzy dwa inne.
$list->insertAfter(new Linked_List_Node('Javascript'));

// Wywietlenie listy w postaci tekstowej:  PHP, Javascript, Perl.
echo '<p>', $list->asString(), '</p>';

// Usunicie ostatniego elementu.
$list->next->removeAfter();

// Ponowne wywietlenie listy: PHP, Javascript.
echo '<p>', $list->asString(), '</p>';
?>
