<?php
// Zdefiniowanie klasy przeciajcej definicj metody.
class Money {
    // Definicja funkcji dodawania obsugujcej szereg rnych odmian.
    public function __call($name, $args) {
        // Jeli zastosowano nazw funkcji 'format':
        if (($name == 'format') && (count($args) == 1)) {
            // Jeli pierwszy argument jest cigiem znakw:
            if (is_string($args[0])) {
                // Wywoanie tekstowej wersji metody formatujcej.
                return $this->_format_string($args[0]);
            } elseif (is_numeric($args[0])) {
                // W przypadku, gdy argumentem jest liczba, wywoanie wersji przeznaczonej dla liczb.
                return $this->_format_number($args[0]);
            } elseif (is_array($args[0])) {
                // Wykorzystanie wersji z argumentem w postaci tablicy.
                return $this->_format_array($args[0]);
            }
        }

        // W innym przypadku wywoanie metody jest nieprawidowe  wyjcie.
        trigger_error('Nieprawidowy dostp do metody', E_USER_ERROR);
    }

    // Zdefiniowanie prywatnej, wewntrznej funkcji formatujcej liczb w postaci waluty.
    private function _format_number($number) {
        // Zaokrglenie liczby do 2 miejsc dziesitnych.
        $number = round($number, 2);

        // Wywietlenie liczby z zastosowaniem formatowania.
        return '$' . number_format($number, 2);
    }

    // Zdefiniowanie prywatnej, wewntrznej funkcji formatujcej cig znakw jako walut.
    private function _format_string($str) {
        // Uporzdkowanie cigu znakw poprzez usunicie wszystkich znakw z wyjtkiem cyfr.
        $str = preg_replace('/[^0-9.]/', '', $str);

        // Sprawdzenie, czy istnieje tylko jeden separator czci dziesitnej.
        $str = preg_replace('/\.([^.]*)(?=\.)/', '$1', $str);

        // Teraz, kiedy wiadomo, e cig znakw jest uporzdkowany, wywoanie dla niego metody             
        // formatowania liczb.
        return $this->_format_number($str);
    }

    // Zdefiniowanie prywatnej, wewntrznej funkcji formatujcej tablic jako walut.
    private function _format_array($arr) {
        // Przetwarzanie w ptli caej tablicy.
        $new = array();
        foreach ($arr as $a) {
            // W zalenoci od tego, czy element tablicy jest cigiem znakw, czy nie, wywoanie odpowiedniej
            // funkcji w celu sformatowania danych i zapisanie ich w nowej tablicy.
            if (is_string($a)) {
                $new[] = $this->_format_string($a);
            } else {
                $new[] = $this->_format_number($a);
            }
        }

        // Zwrcenie nowej tablicy.
        return $new;
    }
}

// Utworzenie nowego obiektu.
$my_money = new Money();

// Sprawdzenie wyniku wywoania tej metody na rne sposoby.
// Jeli argument jest liczb: $1,234.57:
echo '<p>Metoda wywoana z argumentem w postaci liczby: ', $my_money->format(1234.567), '</p>';
// Metoda wywoana z argumentem w postaci tekstowej, zawierajca wewntrz troch mieci: $7,561.20.
echo '<p>Metoda wywoana z argumentem w postaci tekstowej: ', $my_money->format('big7,56.1.2'), '</p>';
// Metoda wywoana z argumentami w postaci tablicy wartoci rnych typw:
//   Array ( [0] => $2.22 [1] => $2,345.64 [2] => $42.00 ).
echo '<p>Metoda wywoana z argumentami w postaci pojedynczych liczb: ';
print_r($my_money->format(array(2.217, '2-345.64', 42)));
echo '</p>';
?>
