<?php
// Zdefiniowanie klasy przeciajcej definicj metody.
class Overloaded_Math {
    // Definicja funkcji dodawania obsugujcej szereg rnych odmian.
    public function __call($name, $args) {
        // Jeli zastosowano nazw funkcji 'add':
        if ($name == 'add') {
            // Jeli pierwszy argument jest cigiem znakw:
            if (is_string($args[0])) {
                // Konkatenacja wszystkich cigw znakw.
                return implode('', $args);
            } elseif ((count($args) == 1) && is_array($args[0])) {
                // Mamy dokadnie jeden argument. Jest nim tablica.
                // Zsumowanie zapisanych w niej wartoci.
                return array_sum($args[0]);
            } elseif ((count($args) > 1) && is_numeric($args[0])) {
                // Jeli jest wicej ni jeden argument i jeli
                // co najmniej pierwszy z nich jest liczb, dodanie ich do siebie.
                return array_sum($args);
            }
        }

        // W innym przypadku wywoanie metody jest nieprawidowe  wyjcie.
        trigger_error('Nieprawidowy dostp do metody', E_USER_ERROR);
    }
}

// Utworzenie nowego obiektu.
$mobj = new Overloaded_Math();

// Sprawdzenie wyniku wywoania tej metody na rne sposoby.
// Argumenty s cigami znakw: 'CzerwonyBiayNiebieski'.
echo '<p>Metoda wywoana z argumentami znakowymi: ', $mobj->add('Czerwony', 'Biay', 'Niebieski'), '</p>';
// Argumenty w postaci tablicy liczb: 16.
echo '<p>Metoda wywoana z argumentami przekazanymi w tablicy liczb: ', $mobj->add(array(7, 6, 3)), '</p>';
// Argumenty w postaci pojedynczych liczb: 42.
echo '<p>Metoda wywoana z argumentami w postaci pojedynczych liczb: ',
    $mobj->add(37.83, 3.17, 1), '</p>';
?>
