<?php
// Definicja klasy, w ktrej bd przechowywane wartoci przekazanych waciwoci
//  sformatowane w odpowiedni sposb.
class Data_Formatter {
    // Tablica do przechowywania danych.
    private $data = array();

    // Metoda ustawiajca dowoln zmienn przekazan do obiektu.
    public function __set($name, $value) {
        if (is_int($value)) {
            // Jeli jest to liczba cakowita, sformatowanie jej z wykorzystaniem przecinkw, ale bez kropki              
            // dziesitnej.
            $new_value = number_format($value, 0);
        } elseif (is_float($value)) {
            // Jeli jest to warto zmiennoprzecinkowa, sformatowanie jej z wykorzystaniem przecinkw              
            // i 2 miejsc dziesitnych.
            $new_value = number_format($value, 2);
        } elseif (is_bool($value)) {
            // W przypadku wartoci typu boolean, przeksztacenie jej na cig 'true' lub 'false'.
            $new_value = $value ? 'true' : 'false';
        } else {
            // W innym przypadku zapisanie danych bez formatowania.
            $new_value = $value;
        }

        // Zapisanie danych w tablicy.
        $this->data[$name] = $new_value;
    }

    // Metoda zwracajca dowolne ustawione wartoci.
    public function __get($name) {
        if (isset($this->data[$name])) { return $this->data[$name]; }
    }

    // Metoda umoliwiajca dziaanie funkcji isset dla utworzonych zmiennych.
    public function __isset($name) {
        return isset($this->data[$name]);
    }

    // Metoda umoliwiajca wywoywanie funkcji unset dla tych zmiennych.
    public function __unset($name) {
        unset($this->data[$name]);
    }
}

// Utworzenie obiektu do przechowywania danych i zapisanie w nim przykadowych danych.
$data = new Data_Formatter();
$data->number = 1200;
$data->money = 189000.452;
$data->lies = false;
$data->place = 'Mount Airy';

// Wywietlenie wartoci w celu uzyskania sformatowanych danych:
//   1,200     189,000.45     false     Mount Airy
echo "<p>Warto zmiennej 'number' to {$data->number}</p>";
echo "<p>Warto zmiennej 'money' to {$data->money}</p>";
echo "<p>Warto zmiennej 'lies' to {$data->lies}</p>";
echo "<p>Warto zmiennej 'place' to {$data->place}</p>";
?>
