<?php
// Definicja klasy, ktra przecia nazw zmiennej  pozwala na zapisanie
//  w tej samej nazwie zmiennej zarwno liczb, jak i tekstu.
class Multi_Data_Holder {
    // Zmienne do przechowywania rnych wersji waciwoci o tej samej nazwie.
    private $number = array();
    private $text = array();

    // Zdefiniowanie metody __set, ktra zapisuje dane na podstawie typu wartoci.
    public function __set($name, $value) {
        // Sprawdzenie, czy typ danych jest dozwolony i zapisanie ich w odpowiedni sposb.
        //  W przypadku typu danych int lub float, zapisanie ich jako liczb.
        if (is_int($value) || is_float($value)) {
            $this->number[$name] = $value;
        } elseif (is_string($value)) {
            $this->text[$name] = $value;
        }
    }

    // Definicja metody isset uwzgldniajca rne typy wartoci.
    public function __isset($name) {
        // Jeli zmienna istnieje w dowolnej postaci, zwrcenie wartoci true.
        return isset($this->number[$name]) || isset($this->text[$name]);
    }

    // Zdefiniowanie metody __unset, ktra pozwala na zniszczenie wszystkich wartoci za pomoc funkcji unset.
    public function __unset($name) {
        unset($this->number[$name]);
        unset($this->text[$name]);
    }

    // Nie da si zdefiniowa metody get, ktra wiedziaaby, ktr warto naley zwrci.
    //  W zwizku z tym zdefiniujemy funkcj, ktra pobiera drugi parametr o
    //  wartoci 'number' lub 'text' i na tej podstawie decyduje, ktr warto naley zwrci.
    public function value($name, $type) {
        // Wykorzystanie zmiennej $type do przechowywania nazw zmiennych, w celu zwrcenia waciwej              
        // wartoci.
        return $this->{$type}[$name];
    }
}

// Utworzenie obiektu do przechowywania danych.
$data = new Multi_Data_Holder();

// Zapisanie liczby i jej tekstowej reprezentacji.
$data->x = 173;
$data->x = 'sto siedemdziesit trzy';

// Wywietlenie liczby i jej tekstowej reprezentacji.
echo '<p>Liczb ', $data->value('x', 'number'), ' czyta si jako: ',
    $data->value('x', 'text'), '</p>';

// Zniszczenie wartoci za pomoc funkcji unset i uycie funkcji isset w celu sprawdzenia, czy operacja przebiega 
// prawidowo.
unset($data->x);
echo '<p>Warto ', isset($data->name) ? 'jest ' : 'nie jest ', 'ustawiona.</p>';
?>
