<?php
// Definicja klasy, w ktrej bd przechowywane wartoci poszczeglnych waciwoci.
class Data_Holder {
    // Tablica do przechowywania danych.
    private $data = array();

    // Metoda ustawiajca dowoln zmienn przekazan do obiektu.
    // Zapisanie jej w tablicy.
    public function __set($name, $value) {
        $this->data[$name] = $value;
    }

    // Metoda zwracajca dowolne ustawione wartoci.
    public function __get($name) {
        if (isset($this->data[$name])) { return $this->data[$name]; }
    }

    // Metoda umoliwiajca dziaanie funkcji isset dla utworzonych zmiennych.
    public function __isset($name) {
        return isset($this->data[$name]);
    }

    // Metoda umoliwiajca wywoywanie funkcji unset dla tych zmiennych.
    public function __unset($name) {
        unset($this->data[$name]);
    }
}

// Utworzenie obiektu do przechowywania danych i zapisanie w nim przykadowych danych.
$data = new Data_Holder();
$data->name = 'Franciszka';

// Wyweitlenie wartoci w celu sprawdzenia, czy dziaa metoda __get:
echo "<p>Warto zmiennej 'name' to {$data->name}</p>";

// Zniszczenie wartoci za pomoc funkcji unset i uycie funkcji isset w celu sprawdzenia, czy operacja przebiega 
//prawidowo.
unset($data->name);
echo '<p>Warto ', isset($data->name) ? 'jest ' : 'nie jest ', 'ustawiona.</p>';
?>

