<?php
// Zdefiniowanie interfejsu, ktry umoliwi konwersj obiektw na cigi znakw.
interface conversionOptions {
    public function asString();
    public function asHTML();
}

// Zdefiniowanie klasy 'kot' implementujcej interfejs.
class kot implements conversionOptions {
    // Waciwoci klasy kot.
    public $name;
    public $color;

    // Konstruktor wymagajcy podania nazwy.
    public function __construct($namesake) {
        $this->name = $namesake;
    }

    // Implementacja tekstowych funkcji interfejsu.
    public function asString() {
        return "Kot - Nazwa: {$this->name}, Kolor: {$this->color}";
    }

    // Implementacja funkcji interfejsu obsugujcych HTML.
    public function asHTML() {
        return "<ul><li>Kot</li><ul><li>Nazwa: {$this->name}</li>
<li>Kolor: {$this->color}</li></ul></ul>";
    }
}

// Zdefiniowanie klasy, ktra implementuje interfejs dla definicji akronimw.
class acronym implements conversionOptions {
    // Waciwoci akronimu.
    private $name;
    private $definition;

    // Konstruktor wymagajcy podania akronimu i jego definicji.
    public function __construct($entry, $def) {
        $this->name = $entry;
        $this->definition = $def;
    }

    // Implementacja tekstowych funkcji interfejsu.
    public function asString() {
        return "{$this->name}: {$this->definition}";
    }

    // Implementacja funkcji interfejsu obsugujcych HTML.
    public function asHTML() {
        return "<dl><dt>{$this->name}</dt>
<dd>{$this->definition}</dd></dl>";
    }
}

// Utworzenie egzemplarza klasy kot i zdefiniowanie danych.
$my_cat = new kot('Filemon');
$my_cat->color = 'szary';

// Zwrcenie tekstowej reprezentacji obiektu kot i wywietlenie jej.
$catstring = $my_cat->asString();
echo "<pre>{$catstring}</pre>\n";

// Wykonanie tych samych dziaa z wykorzystaniem formatu HTML.
echo $my_cat->asHTML();

// Utworzenie definicji akronimu.
$my_anac = new acronym('TTA', 'Towarzystwo Twrczego Anachronizmu');

// Przeksztacenie akronimu na posta tekstow.
$anac = $my_anac->asString();
echo "<pre>{$anac}</pre>\n";

// Wywietlenie obiektu w formacie HTML.
echo $my_anac->asHTML();
?>
