<?php
// Definicja klasy abstrakcyjnej opisujcej zwierzta.
abstract class animal {
    // Deklaracja zmiennych (waciwoci).
    public $name;

    // Deklaracja wsplnego konstruktora, do ktrego obowizkowo trzeba przekaza nazw.
    public function __construct($namesake) {
        $this->name = $namesake;
    }

    // Deklaracja metod abstrakcyjnych, ktre musz by zaimplementowane w klasach wszystkich zwierzt.
    abstract public function makeSound();
    abstract public function eat($what);
}

// Definicja klasy kot.
class kot extends animal {
    public function makeSound() {
        echo "Miau\n";
    }

    public function eat($what) {
        switch ($what) {
            case 'granulat':
            case 'kocia karma':
            case 'myszka':
            case 'ptak':
                echo "Kot mwi pycha!\n";
                break;
            case 'trawa':
            case 'sieczka':
            case 'wosy':
                echo "Kot mruczy z zadowoleniem.\n";
                break;
            default:
                echo "Kot gwatownie podnosi gow i odchodzi.\n";
        }
    }
}

// Definicja klasy krowa.
class krowa extends animal {
    public function makeSound() {
        echo "Muuuuuuuu!\n";
    }

    public function eat($what) {
        switch ($what) {
            case 'trawa':
            case 'siano':
            case 'sl':
                echo "Krowa przeuwa.\n";
                break;
            default:
                echo "Krowa odchodzi, ignorujc karm.\n";
        }
    }
}

// Deklaracja kota i krowy.
$my_cat = new kot('Mruczek');
$my_cow = new krowa('Gertruda');

echo '<pre>';

// Kot wydaje dwik: Miau!
$my_cat->makeSound();

// Krowa  wydaje dwik: Muuuuuuuu!
$my_cow->makeSound();

// Co robi zwierzta, jedzc traw?
$my_cat->eat('trawa');
$my_cow->eat('trawa');

echo '</pre>';
?>
