<?php
// Zdefiniowanie klasy obsugi pyt kompaktowych.
class cd {
    // Deklaracja zmiennych (waciwoci).
    public $artist;
    public $title;
    protected $tracks;
    private $disk_id;

    // Deklaracja konstruktora.
    public function __construct() {
        // Wygenerowanie losowego identyfikatora pyty.
        $this->disk_id = sha1('cd' . time() . rand());
    }

    // Utworzenie metody, ktra zwraca identyfikator dysku. Nie mona do niej uzyska bezporedniego
    // dostpu, poniewa zadeklarowano j jako prywatn.
    public function get_disk_id() {
        return $this->disk_id;
    }
}

// Rozszerzenie klasy i dodanie obsugi albumw skdajcych si z wielu pyt.
class cd_album extends cd {
    // Deklaracja licznika pyt CD.
    protected $num_disks;

    // Konstruktor umoliwiajcy podanie liczby pyt.
    public function __construct($disks = 1) {
        $this->num_disks = $disks;

        // Wymuszenie uruchomienia konstruktora klasy macierzystej
        //  w celu utworzenia identyfikatora pyty CD.
        parent::__construct();
    }

    // Utworzenie funkcji zwracajcej true lub false w zalenoci od tego, czy jest to
    // album skadajcy si z wielu pyt, czy nie.
    public function is_multi_cd() {
        return ($this->num_disks > 1) ? true : false;
    }
}

// Utworzenie egzemplarza obiektu klasy 'cd_album'.  Zdefiniowanie obiektu dla albumu zoonego z 3 pyt.
$mydisk = new cd_album(3);

// Wykorzystanie zdefiniowanej funkcji do odczytania i wywietlenia identyfikatora.
echo '<p>Identyfikator pyty kompaktowej: ', $mydisk->get_disk_id(), '</p>';

// Wykorzystanie metody w celu stwierdzenia, czy jest to album skadajcy si z wielu pyt.
echo '<p>Czy jest to album zoony z wielu pyt? ',
    ($mydisk->is_multi_cd()) ? 'Tak' : 'Nie',
    '</p>';
?>

