<?php
// Deklaracja funkcji automatycznego adowania i jej rejestracja za pomoc biblioteki SPL.
function __autoload($classname) {
    @require_once "klasa-{$classname}.php";
}

// Utworzenie innej funkcji.
function another_class_autoload($classname) {
    @require_once "obj-{$classname}.php";
}

// Przed zarejestrowaniem funkcji sprawdzamy, czy zadeklarowano funkcj  __autoload().
if (function_exists('__autoload')) {
    spl_autoload_register('__autoload');
}

// Rejestracja naszej funkcji.
spl_autoload_register('another_class_autoload');

// Utworzenie egzemplarza obiektu klasy 'cd'.
//   Operacja ta zainicjuje prb zaadowania pliku: klasa-cd.php lub obj-cd.php.
$mydisk = new cd();
?>
