<?php
// Wygenerowanie listy kontroli dostpu.
$access = array('akowalski', 'cnowak', 'hwojtaszek', 'rmeryk', 'rbielski');
$admin = array('ebielski', 'eczarnecki');

// Funkcja sprawdza uprawnienia uytkownika. Naley przekaza nazw uytkownika i opcjonalnie informacj o tym,
// czy s potrzebne uprawnienia administratora.
function check_access($username, $adminonly = false) {
    global $access, $admin;

    // W przypadku administratora funkcja zawsze zwraca true.
    if (in_array($username, $admin)) {
        return true;
    }

    // W przypadku uytkownikw, ktrzy nie s administratorami, funkcja zwraca true, jeli znajduj si oni na licie.
    if (!($adminonly) && in_array($username, $access)) {
        return true;
    }

    // W innym przypadku uytkownik nie powinien uzyska dostpu.
    return false;
}

// Wyprbowanie kilku przypadkw testowych. Najpierw obaj uytkownicy maj uprawnienia.
echo "<p>'rbielski' ",
    check_access('rbielski') ? 'ma uprawnienia' : 'NIE ma uprawnie' ,".</p>";
echo "<p>'eczarnecki' ",
    check_access('eczarnecki') ? 'ma uprawnienia' : 'NIE ma uprawnie' ,".</p>";

// Administrator  eczarnecki ma uprawnienia, ale uytkownik rbielski nie ma uprawnie.
echo "<p>'rbielski' ",
    check_access('rbielski', true) ? 'jest' : 'NIE jest' ," administratorem.</p>";
echo "<p>'eczarnecki' ",
    check_access('eczarnecki', true) ? 'jest' : 'NIE jest' ," administratorem.</p>";
?>

