<?php
// Biblioteka dziaa na macierzach.
// We wszystkich funkcjach zaoono, e macierz jest dwuwymiarow tablic, gdzie pierwszy
//  indeks (array[x]) oznacza wiersz, a drugi indeks (array[x][y]) oznacza kolumny.

// Najpierw utworzymy kilka funkcji pomocniczych.

// Funkcja sprawdzajca, czy macierz ma prawidowy format, tzn. czy jest w peni prostoktna i
//  czy nie brakuje w niej niektrych elementw.
function _matrix_well_formed($matrix) {
    // Jeli argument nie jest tablic, format macierzy jest nieprawidowy  zwrcenie false.
    if (!(is_array($matrix))) {
        return false;
    } else {
        // Obliczenie liczby wierszy.
        $rows = count($matrix);

        // Ptla dla wszystkich wierszy.
        for ($r = 0; $r < $rows; $r++) {
            // Sprawdzenie, czy wiersz istnieje i czy jest on tablic. Nastpnie naley sprawdzi, czy
            // wiersz jest tablic o indeksach numerycznych
            // i pierwszym indeksie rwnym zeru.
            if (!(isset($matrix[$r]) && is_array($matrix[$r]))) {
                return false;
            } else {
                // Obliczenie liczby kolumn dla wiersza zerowego.
                if ($r == 0) {
                    $cols = count($matrix[$r]);
                // Sprawdzenie, czy liczba kolumn we wszystkichh wierszach jest identyczna. Jeli nie, 
                                  // zakoczenie dziaania funkcji.
                } elseif (count($matrix[$r]) != $cols) {
                    return false;
                }

                // Przetwarzanie w ptli wszystkich kolumn biecego wiersza.
                for ($c = 0; $c < $cols; $c++) {
                    // Sprawdzenie, czy okrelony eleement zdefiniowano i czy jest on liczb.
                    if (!(isset($matrix[$r][$c]) &&
                            is_numeric($matrix[$r][$c]))) {
                        return false;
                    }
                }
            }
        }
    }

    // Jeli sterowanie doszo do tego miejsca, to w macierzy nie znaleziono 
    //  niczego nieprawidowego.
    return true;
}

// Funkcja zwracajca liczb wierszy w macierzy.
//  Funkcja nie sprawdza poprawnoci macierzy. Zakada, e jej format jest prawidowy.
function _matrix_rows($matrix) {
    return count($matrix);
}

// Funkcja zwracajca liczb kolumn w macierzy.
//  Funkcja nie sprawdza poprawnoci macierzy. Zakada, e jej format jest prawidowy.
function _matrix_columns($matrix) {
    return count($matrix[0]);
}

// Funkcja wykonuje dziaania na elementach macierzy, na przykad dodawanie
// lub odejmowanie. Aby z niej skorzysta, naley przekaza argumenty w postaci 2 macierzy i operacji
// do wykonania w postaci cigu znakw: '+', '-'.
function matrix_element_operation($a, $b, $operation) {
    // Sprawdzenie, czy obie macierze maj prawidowy format.
    $valid = false;
    if (_matrix_well_formed($a) && _matrix_well_formed($b)) {
        // Sprawdzenie, czy macierze maj t sam liczb kolumn i wierszy.
        $rows = _matrix_rows($a);
        $columns = _matrix_columns($a);

        if (($rows == _matrix_rows($b)) &&
                ($columns == _matrix_columns($b))) {
            // Macierze s prawidowe, mona kontynuowa dziaanie.
            $valid = true;
        }
    }

    // Jeli ktra z macierzy ma nieprawidowy format, zwrcenie false.
    if (!($valid)) { return false; }

    // Dla kadego elementu z pierwszej macierzy wykonanie operacji 
    // z odpowiadajcym mu elementem z drugiej macierzy.
    for ($r = 0; $r < $rows; $r++) {
        for ($c = 0; $c < $columns; $c++) {
            eval('$a[$r][$c] '.$operation.'= $b[$r][$c];');
        }
    }

    // Zwrcenie wynikowej macierzy.
    return $a;
}

// Funkcja wykonuje pene dziaania na macierzach, na przykad dodawanie dwch macierzy
// lub mnoenie dwch macierzy. Podobnie jak powyej, do funkcji naley przekaza macierze
// oraz symbol operacji: '*', '-', '+'.
function matrix_operation($a, $b, $operation) {
    // Sprawdzenie, czy obie macierze maj prawidowy format.
    $valid = false;
    if (_matrix_well_formed($a) && _matrix_well_formed($b)) {
        // Sprawdzenie, czy macierze maj odpowiedni liczb kolumn i wierszy.
        // Liczba wierszy w macierzy A powinna by rwna liczbie kolumn w macierzy B.
        $rows = _matrix_rows($a);
        $columns = _matrix_columns($a);

        if (($columns == _matrix_rows($b)) &&
                ($rows == _matrix_columns($b))) {
            // Macierze maj prawidowy format. Mona kontynuowa dziaanie.
            $valid = true;
        }
    }

    // Jeli ktra macierz ma nieprawidowy format, zwrcenie false.
    if (!($valid)) { return false; }

    // Utworzenie pustej macierzy o waciwym rozmiarze i ustawienie jej wszystkich elementw na 0.
    $new = array_fill(0, $rows, array_fill(0, $rows, 0));

    // Dla kadego wiersza w macierzy a
    for ($r = 0; $r < $rows; $r++) {
        // Dla kadej kolumny w macierzy b
        for ($c = 0; $c < $rows; $c++) {
            // Pobranie poszczeglnych elementw z kolumny macierzy b razem z elementami 
                         // w wierszu macierzy a.
            // Dodanie wynikw i zapisanie w nowej tablicy.
            // Ptla dla wszystkich kolumn w macierzy a 
            for ($ac = 0; $ac < $columns; $ac++) {
                // Wykonanie dziaania.
                eval('$new[$r][$c] += $a[$r][$ac] '.
                    $operation.' $b[$ac][$c];');
            }
        }
    }

    // Zwrcenie wynikowej macierzy.
    return $new;
}

// Funkcja do wykonywania dziaa skalarnych. Pobieramy warto skalarn oraz
// operacj do wykonania i wykonujemy operacj dla kadego elementu macierzy.
function matrix_scalar_operation($matrix, $scalar, $operation) {
    // Sprawdzenie, czy format macierzy jest prawidowy.
    if (_matrix_well_formed($matrix)) {
        $rows = _matrix_rows($matrix);
        $columns = _matrix_columns($matrix);

        // Pomnoenie poszczeglnych elementw macierzy przez warto skalarn.
        for ($r = 0; $r < $rows; $r++) {
            for ($c = 0; $c < $columns; $c++) {
                eval('$matrix[$r][$c] '.$operation.'= $scalar;');
            }
        }

        // Zwrcenie wynikowej macierzy.
        return $matrix;
    } else {
        // Format macierzy by nieprawidowy.
        return false;
    }
}

// Przydatna funkcja do wywietlania macierzy (w postaci tabeli HTML).
function matrix_print($matrix) {
    // Sprawdzenie, czy format macierzy jest prawidowy.
    if (_matrix_well_formed($matrix)) {
        $rows = _matrix_rows($matrix);
        $columns = _matrix_columns($matrix);

        // Pocztek tabeli.
        echo '<table>';

        // Dla kadego wiersza w macierzy.
        for ($r = 0; $r < $rows; $r++) {
            // Rozpoczcie wiersza.
            echo '<tr>';

            // Dla kadej kolumny w tym wierszu.
            for ($c = 0; $c < $columns; $c++) {
                // Wywietlenie elementu.
                echo "<td>{$matrix[$r][$c]}</td>";
            }

            // Zakoczenie wiersza.
            echo '</tr>';
        }

        // Zakoczenie tabeli.
        echo "</table>\n";
    } else {
        // Format macierzy by nieprawidowy.
        return false;
    }
}

// Kilka dziaa testowych. Kilka instrukcji formatujcych.
echo "<style>table { border: 1px solid black; margin: 20px; }
td { text-align: center; }</style>\n";

// Wykonanie testowych operacji na elementach. Potrzebne s macierze o identycznych wymiarach.
$m1 = array(
    array(5, 3, 2),
    array(3, 0, 4),
    array(1, 5, 2),
    );
$m2 = array(
    array(4, 9, 5),
    array(7, 5, 0),
    array(2, 2, 8),
    );

// W rezultacie dodawania uzyskamy nastpujce wyniki:  9    12     7
//                                                     10     5     4
//                                                      3     7    10
matrix_print(matrix_element_operation($m1, $m2, '+'));

// W rezultacie odejmowania uzyskamy nastpujce wyniki: 1    -6    -3
//                                                      -4    -5     4
//                                                      -1     3    -6
matrix_print(matrix_element_operation($m1, $m2, '-'));

// W rezultacie mnoenia przez warto skalarn uzyskamy nastpujce wyniki: 8  18  10
//                                                                          14  10   0
//                                                                           4   4  16
matrix_print(matrix_scalar_operation($m2, 2, '*'));

// Zdefiniowanie macierzy do wykonania penych dziaa na macierzach.
// Wymiary macierzy musz si uzupenia.
$m3 = array(
    array(1, 3, 5),
    array(-2, 5, 1),
    );
$m4 = array(
    array(1, 2),
    array(-2, 8),
    array(1, 1),
    );

// Wynik mnoenia macierzy:      0    31
//                             -11    37
matrix_print(matrix_operation($m3, $m4, '*'));

// Wynik dodawania macierzy:  9  20
//                            4  15
matrix_print(matrix_operation($m3, $m4, '+'));
?>
