<?php
// Implementacja sortowania Shella.
function shell_sort(&$a) {
    $count = count($a);

    // Wyznaczenie sekwencji  2x + 1, gdzie najwiksza warto jest mniejsza
    //  od liczby elementw w tablicy.
    $columns = 1;
    while ($columns < $count) {
        $columns = $columns * 2 + 1;
    }

    // Posunlimy si o jedn pozycj za daleko, zatem cofamy si o jeden.
    $columns = ($columns - 1) / 2;
    // Liczba kolumn do posortiwania wynosi CO NAJMNIEJ 1.
    while ($columns > 0) {
        // Ptla dla biecej liczby kolumn.
        for ($c = 0; $c < $columns; $c++) {
            // Ptla dla wszystkich elementw w tej kolumnie.
            for ($i = $columns; $i < $count; $i += $columns) {
                // Zapisanie biecej wartoci do porwnania.
                $value = $a[$i];

                // Ptla wstecz od biecej wartoci do osignicia
                //  pocztku tablicy lub wartoci mniejszej od biecej.
                for ($x = $i - $columns;
                        ( ($x >= 0) && ($a[$x] > $value) );
                        $x -= $columns) {
                    // Przestawienie wartoci na pozycj wczeniejsz.
                    $a[$x + $columns] = $a[$x];
                }

                // Wstawienie elementu na waciw pozycj.
                $a[$x + $columns] = $value;
            }
        }

        // Po zakoczeniu sortowania jednego zbioru kolumn
        //  zmniejszamy ich liczb.
        $columns = ($columns - 1) / 2;
    }
}

// Utworzenie tablicy wartoci.
$values = array(73, 3, 42, 6, 14, 23, 15, 9, 74, 1, 234, 45, 23, 76, 12, 3);

// Posortowanie ich.
shell_sort($values);

// Wywietlenie uporzdkowanej tablicy.
//  1 3 3 6 9 12 14 15 23 23 42 45 73 74 76 234
foreach ($values as $v) { echo "{$v} "; }
?>
