<?php
// Biblioteka implementujca kolejk w jzyku PHP za porednictwem tablic.

// Funkcja Initialize tworzy now kolejk.
function &queue_initialize() {
    // W tym przypadku funkcja zwraca now tablic.
    $new = array();
    return $new;
}

// Funkcja niszczy kolejk.
function queue_destroy(&$queue) {
    // W tym celu mona skorzysta z wbudowanej funkcji unset.
    unset($queue);
}

// Operacja enqueue dodaje now warto na kocu kolejki.
function queue_enqueue(&$queue, $value) {
    // Poniewa operacja polega na dodaniu wartoci na kocu tablicy, mona skorzysta
    // ze skrtu  pary nawiasw [] za nazw tablicy. Jest to sposb szybszy od wywoania funkcji array_push.
    $queue[] = $value;
}

// Operacja dequeue usuwa pierwszy element z kolejki i zwraca go do skryptu wywoujcego.
function queue_dequeue(&$queue) {
    // Wykorzystanie funkcji array_ shift.
    return array_shift($queue);
}

// Operacja peek zwraca kopi pierwszego elementu kolejki, ale pozostawia go na miejscu.
function queue_peek(&$queue) {
    // Zwrcenie kopii pierwszego elementu kolejki
    //  (z pocztku tablicy).
    return $queue[0];
}

// Funkcja size zwraca liczb elementw w kolejce.
function queue_size(&$queue) {
    // Poprawn warto mona uzyska za pomoc funkcji count:
    return count($queue);
}

// Funkcja rotate pobiera element z pocztku kolejki i umieszcza go na kocu kolejki.
function queue_rotate(&$queue) {
    // Usunicie pierwszego elementu i umieszczenie go na kocu.
    $queue[] = array_shift($queue);
}

// Wykorzystanie funkcji obsugi kolejki do stworzenia przykadowej kolejki i wykonanie kilku operacji.
// Dodanie kilku sw do kolejki.
$myqueue =& queue_initialize();
queue_enqueue($myqueue, 'Opal');
queue_enqueue($myqueue, 'Delfin');
queue_enqueue($myqueue, 'Pelikan');

// Zawarto kolejki to: Opal, Delfin, Pelikan.

// Sprawdzenie rozmiaru kolejki. Poprawna warto wynosi 3.
echo '<p>Rozmiar kolejki wynosi: ', queue_size($myqueue), '</p>';

// Podejrzenie pierwszego elementu kolejki. Poprawna warto to: Opal.
echo '<p>Na pocztku kolejki znajduje si: ', queue_peek($myqueue), '</p>';

// Obrt kolejki. Po operacji bdzie ona miaa nastpujc zawarto: Delfin, Pelikan, Opal.
queue_rotate($myqueue);

// Usunicie pierwszego elementu z kolejki. Operacja zwraca nastpujc warto: Delfin.
echo '<p>Usunito nastpujcy element z pocztku kolejki: ',
    queue_dequeue($myqueue), '</p>';

// Zniszczenie kolejki.
queue_rotate($myqueue);
?>
