<?php
// Biblioteka implementujca stos w PHP za porednictwem tablic.

// Funkcja Initialize tworzy nowy stos.
function &stack_initialize() {
    // W tym przypadku funkcja zwraca now tablic.
    $new = array();
    return $new;
}

// Funkcja niszczy stos.
function stack_destroy(&$stack) {
    // W tym celu mona skorzysta z wbudowanej funkcji unset.
    unset($stack);
}

// Operacja push umieszcza now warto na wierzchoku stosu.
function stack_push(&$stack, $value) {
    // Poniewa operacja polega na dodaniu wartoci na kocu tablicy, mona skorzysta
    // ze skrtu  pary nawiasw [] za nazw tablicy. Jest to sposb szybszy od wywoania funkcji array_push.
    $stack[] = $value;
}

// Operacja pop pobiera warto z wierzchoka stosu i zwraca j do skryptu wywoujcego.
function stack_pop(&$stack) {
    // Wykorzystanie funkcji array_ pop.
    return array_pop($stack);
}

// Operacja peek zwraca kopi wartoci z wierzchoka stosu, ale pozostawia j na miejscu.
function stack_peek(&$stack) {
    // Zwrcenie kopii wartoci z wierzchoka stosu (koca tablicy).
    return $stack[count($stack)-1];
}

// Funkcja size zwraca liczb elementw stosu.
function stack_size(&$stack) {
    // Poprawn warto mona uzyska za pomoc funkcji count.
    return count($stack);
}

// Operacja swap pobiera dwie wartoci ze stosu i zamienia je miejscami.
function stack_swap(&$stack) {
    // Sprawdzenie liczby elementw stosu.
    $n = count($stack);

    // Wykonywanie dziaa tylko wtedy, gdy na stosie znajduje si wicej ni 1 element.
    if ($n > 1) {
        // Zapisanie kopii elementw od drugiego do ostatniego.
        $second = $stack[$n-2];
        // Umieszczenie ostatniego elementu na przedostatniej pozycji.
        $stack[$n-2] = $stack[$n-1];
        // Umieszczenie przedostatniego elementu na ostatniej pozycji.
        $stack[$n-1] = $second;
    }
}

// Funkcja dup pobiera warto z wierzchoka stosu, dubluje j,
//  a nastpnie umieszcza z powrotem na stosie.
function stack_dup(&$stack) {
    // Prosta operacja polegajca na ponownym umieszczeniu na stosie elementu z jego wierzchoka.
    $stack[] = $stack[count($stack)-1];
}

// Wykorzystanie funkcji obsugi stosu do stworzenia przykadowego stosu i wykonanie kilku operacji.
//  Odoenie kilku liczb na stosie: 73, 74, 5.
$mystack =& stack_initialize();
stack_push($mystack, 73);
stack_push($mystack, 74);
stack_push($mystack, 5);

// Wykonanie duplikatu wierzchoka stosu. Zawarto stosu po operacji:  73, 74, 5, 5.
stack_dup($mystack);

// Sprawdzenie rozmiaru stosu. Poprawna warto wynosi 4.
echo '<p>Rozmiar stosu wynosi: ', stack_size($mystack), '</p>';

// Zdjcie wartoci ze stosu. Uzyskany wynik: 5.
echo '<p>Ze stosu zdjto warto: ', stack_pop($mystack), '</p>';

// Przestawienie miejsc dwch wartoci ze szczytu stosu. Zawarto stosu po operacji: 73, 5, 74.
stack_swap($mystack);

// Podejrzenie elementu na szczycie stosu w celu upewnienia si, e ma on warto 74.
echo '<p>Biecy element na szczycie stosu: ', stack_peek($mystack), '</p>';

// Zniszczenie stosu.
stack_destroy($mystack);
?>
