<style type="text/css">
table { border-collapse: collapse; }
td, th {
    border: 1px solid #333333;
    width: 25px;
    text-align: center;
}
</style>
<?php
// Utworzenie tablicy wartoci. Indeks jest wersj wartoci przeznaczon do wywietlenia.
$values = array("'0'" => '0', 0 => 0, "'1'" => '1', 1 => 1, "'-1'" => '-1',
    -1 => -1, "'2'" => '2', 2 => 2, '0.0' => 0.0, '0.1' => 0.1,
    '-0.1' => -0.1, '1.0' => 1.0, "'0.0'" => '0.0', "'0.1'" => '0.1',
    "'.1'" => '.1', "'-0.1'" => '-0.1', "'-.1'" => '-.1', "'1.0'" => '1.0',
    "'00'" => '00', "'01'" => '01', 'false' => false, 'true' => true,
    "''" => '', "'a'" => 'a', "'b'" => 'b', "'A'" => 'A', 'NULL' => NULL,
    'array()' => array(), "array('a')" => array('a') );

// Utworzenie tablicy funkcji porwna. Indeks jest wersj nazwy przeznaczon do wywietlenia.
$cmp = array (
    '==' => create_function('$a,$b', 'return $a == $b ? "<b>1</b>" : 0;'),
    '===' => create_function('$a,$b', 'return $a === $b ? "<b>1</b>" : 0;'),
    '!=' => create_function('$a,$b', 'return $a != $b ? "<b>1</b>" : 0;'),
    '!==' => create_function('$a,$b', 'return $a !== $b ? "<b>1</b>" : 0;'),
    '<' => create_function('$a,$b', 'return $a < $b ? "<b>1</b>" : 0;'),
    '>' => create_function('$a,$b', 'return $a > $b ? "<b>1</b>" : 0;'),
    '<=' => create_function('$a,$b', 'return $a <= $b ? "<b>1</b>" : 0;'),
    '>=' => create_function('$a,$b', 'return $a >= $b ? "<b>1</b>" : 0;'),
    'strcmp()' => create_function('$a,$b', 'return @strcmp($a,$b);'),
    'strcasecmp()' => create_function('$a,$b', 'return @strcasecmp($a,$b);'),
    );

// Utworzenie tabeli referencyjnej dla kadej funkcji porwnania.
foreach ($cmp as $name => $function) {
    create_reference_table($values, $name, $function);
}

// Funkcja tworzca tabele referencyjne.
function create_reference_table($array, $name, $func) {
    // Pocztek tabeli.
    echo '<br /><table>';
    echo "<caption>Operacje porwna w PHP z wykorzystaniem operatora: {$name}</caption>";

    // Utworzenie pierwszego nagwkowego wiersza.
    echo '<tr><th></th>';
    foreach ($array as $x => $v) { echo "<th>{$x}</th>"; }
    echo "</tr>\n";

    // Porwnanie kadego elementu z pozostaymi.
    foreach ($array as $nm => $y) {
        echo "<tr><th>{$nm}</th>";
        foreach ($array as $x) {
            echo '<td>', $func($x, $y), '</td>';
        }
        echo "</tr>\n";
    }

    // Zakoczenie tabeli.
    echo "</table>\n";
}
?>
