<?php
ob_start();
require '03r02-1.php';
ob_end_clean();

// Funkcja wywietla kalendarz w formacie HTML dla wskazanego miesica i roku.
function print_calendar($month, $year, $weekdaytostart = 0) {
    // O miesicu, dla ktrego generujemy kalendarz, potrzebne s pewne informacje, na przykad znacznik 
        // czasu ostatniego dnia.
    $last = idate('d', last_day($month, $year));

    // Potrzebna jest rwnie informacja o tym, w jaki dzie tygodnia przypada pierwszy dzie miesica.
    // Nazw miesica uzyskamy automatycznie.
    $firstdaystamp = mktime(0, 0, 0, $month, 1, $year);
    $firstwday = idate('w', $firstdaystamp);
    $name = date('F', $firstdaystamp);

    // Aby uatwi realizacj funkcji 'rozpoczcie od dowolnego dnia tygodnia', potrzebna jest
    //  tablica numerw dni tygodnia w uywanym porzdku drukowania.
    $weekorder = array();
    for ($wo = $weekdaytostart; $wo < $weekdaytostart + 7; $wo++) {
        $weekorder[] = $wo % 7;
    }

    // Pocztek tabeli HTML.
    echo "<table><tr><th colspan=\"7\">{$name} {$year}</th></tr>\n";

    // Wywietlenie wiersza z nazwami dni.
    // Wykorzystanie systemu do uzyskania nazw dni tygodnia.
    echo '<tr>';
    // Przetwarzanie w ptli penego tygodnia poczwszy od dnia numer 1.
    foreach ($weekorder as $w) {
        $dayname = date('D',
            mktime(0, 0, 0, $month, 1 - $firstwday + $w, $year));
        echo "<th>{$dayname}</th>";
    }
    echo "</tr>\n";

    // Zainicjowanie licznikw i wykonanie oblicze.
    $onday = 0;
    $started = false;

    // Ptla do ostatniego dnia miesica.
    while ($onday <= $last) {
        // Rozpoczcie nastpnego wiersza w tabeli.
        echo '<tr>';

        // Ptla od 0 do 6 dla dni tygodnia, ale w wybranym porzdku;
        //  do tego celu wykorzystano operator mod.
        foreach ($weekorder as $d) {
            // Jeli jeszcze nie rozpoczto:
            if (!($started)) {
                // Czy dzie biecy odpowiada pierwszemu dniu tygodnia, od ktrego naley rozpocz?
                if ($d == $firstwday) {
                    // Ustawienie zmiennej wskazujcej na fakt rozpoczcia generowania kalendarza 
                                          // i inkrementacja licznika.
                    $started = true;
                    $onday++;
                }
            }

            // Wywietlenie pustej komrki, jeli numer dnia wynosi zero lub
            //  jest wikszy od numeru ostatniego dnia.
            if (($onday == 0) || ($onday > $last)) {
                echo '<td>&nbsp;</td>';
            } else {
                // W innym przypadku wywietlenie numeru dnia i inkrementacja licznika.
                echo "<td>{$onday}</td>";
                $onday++;
            }
        }

        // Zakoczenie wiersza tabeli.
        echo "</tr>\n";
    }

    // Zakonczenie tabeli.
    echo '</table>';
}

// Wygenerowanie dyrektyw formatujcych.
echo '<style>table, td, th { border: 1px solid black; }</style>';

// Wygenerowanie kilku przykadowych tabel.
// Listopad 2005 z niedziel jako pierwszym dniem.
print_calendar(11, 2005);
echo '<br />';

// Utworzenie caorocznego kalendarza dla roku 2006 z poniedziakiem jako pierwszym dniem.
foreach(range(1, 12) as $m) {
    print_calendar($m, 2006, 1);
    echo '<br />';
}
?>
