<?php
// Ustawienie domylnej strefy czasowej na Europe/Warsaw.
date_default_timezone_set('Europe/Warsaw');

// Funkcja zwracajca liczb dni roboczych midzy dwiema datami.
function count_business_days($a, $b) {
    // Sortowanie dat.  Trzeba si dowiedzie, ktra z dat przypada wczeniej.
    if ($a < $b) {
        $first = $a;
        $second = $b;
    } else {
        $first = $b;
        $second = $a;
    }

    // Rozoenie znacznikw czasu na skadowe.
    $f = getdate($first);
    $s = getdate($second);

    // Obliczenie liczby pozostaych dni roboczych w pocztkowym tygodniu.
    // W tym celu naley odj numer dnia w tygodniu od piciu.
    $f_days = 5 - $f['wday'];
    // W przypadku soboty lub niedzieli uzyskamy wynik  -1 lub 5, ale wtedy przyjmujemy do oblicze warto 0.
    if (($f_days == 5) || ($f_days < 0)) { $f_days = 0; }

    // Wykonanie podobnej operacji dla kocowego tygodnia, z t rnic, e liczymy od
    // pocztku tygodnia.  Trzeba si tylko upewni, e sobota liczy si jako 5.
    $s_days = ($s['wday'] > 5) ? 5 : $s['wday'];

    // Obliczenia znacznika czasu dla poudnia w niedziel pocztkowego tygodnia.
    $f_sunday = mktime(12, 0, 0, $f['mon'],
                    $f['mday'] + ((7 - $f['wday']) % 7), $f['year']);

    // Obliczenia znacznika czasu dla poudnia w niedziel poprzedzajc dat kocow.
    $s_sunday = mktime(12, 0, 0, $s['mon'],
                    $s['mday'] - $s['wday'], $s['year']);

    // Obliczenie liczby penych tygodni midzy dwiema datami poprzez odjcie od siebie
    // znacznikw czasu i podzielenie przez liczb sekund w tygodniu. Uzyskany wynik naley
    //  zaokrgli po to, by zawsze uzyska liczb cakowit. W innym przypadku z powodu zmiany czasu 
        // z letniego
    //  na zimowy (lub odwrotnie) uzyskany wynik moe by niedokadny.
    $weeks = round(($s_sunday - $f_sunday) / (3600*24*7));

    // Zwrcenie liczby dni poprzez pomnoenie liczby tygodni przez 5 i dodanie
    // dni roboczych z pocztkowego i kocowego tygodnia.
    return ($weeks * 5) + $f_days + $s_days;
}

// Kilka przykadw:
$date1 = strtotime('12/3/1973 8:13am');
$date2 = strtotime('1/15/1974 10:15pm');
$date3 = strtotime('2/14/2005 1:32pm');

// Obliczenie liczby dni roboczych. Prawidowe wyniki to: 31 & 8109.
echo "<p>Daty dzieli ", count_business_days($date1, $date2), " dni roboczych.</p>";
echo "<p>Daty dzieli ", count_business_days($date2, $date3), " dni roboczych.</p>";
?>
