<?php
// Ustawienie domylnej strefy czasowej na Europe/Warsaw.
date_default_timezone_set('Europe/Warsaw');

// Funkcja zwraca liczb dni midzy dwoma przekazanymi datami.
function count_days($a, $b) {
    // Najpierw naley przeksztaci daty na czci skadowe:
    $a_dt = getdate($a);
    $b_dt = getdate($b);

    // Odtworzenie znacznikw czasu z wykorzystaniem poudnia kadego dnia.
    // Dokadny czas nie ma znaczenia, ale musi to by ta sama godzina w kadym dniu.
    $a_new = mktime(12, 0, 0, $a_dt['mon'], $a_dt['mday'], $a_dt['year']);
    $b_new = mktime(12, 0, 0, $b_dt['mon'], $b_dt['mday'], $b_dt['year']);

    // Odjcie dwch liczb i podzielenie przez liczb sekund przypadajc na dzie.
    // Zaokrglenie wyniku, poniewa przekroczenie granicy zmiany czasu z letniego na zimowy (lub odwrotnie)
    //  spowoduje rnic w czasie o godzin lub dwie.
    return round(abs($a_new - $b_new) / 86400);
}

// Przygotowanie kilku dat
$date1 = strtotime('12/3/1973 8:13am');
$date2 = strtotime('1/15/1974 10:15pm');
$date3 = strtotime('2/14/2005 1:32pm');

// Obliczenie rnic. Powinnimy uzyska wyniki 43 i 11353
echo "<p>Upyno ", count_days($date1, $date2), " dni.</p>";
echo "<p>Upyno ", count_days($date2, $date3), " dni.</p>";
?>
