<?php
// Rne funkcje statystyczne operujce na tablicach.

// Zakres listy to rnica midzy maksymaln a minimaln wartoci.
function array_range($values) {
    // Wykorzystanie wbudowanych funkcji  PHP max i min w celu uatwienia oblicze.
    return max($values) - min($values);
}

// Funkcja obliczajca redni wszystkich wartoci na licie.
function array_mean($values) {
    // Wystarczy zsumowa wszystkie wartoci i podzieli je przez ich liczb.
    return array_sum($values) / count($values);
}

// Mediana to warto ze rodka posortowanej listy lub rednia z dwch
// rodkowych wartoci w przypadku, gdy zbir zawiera parzyst liczb elementw.
function array_median($values) {
    // Posortowanie tablicy.
    sort($values);

    // Obliczenie redniej w przypadku zbioru o parzystej liczbie elementw.
    $length = count($values);
    if ($length % 2) {
        // Zbir zawiera nieparzyst liczb elementw. Zwrcenie rodkowego elementu.
        return $values[$length / 2];
    } else {
        // Parzysta liczba elementw  podzielenie jej przez 2 w celu uzyskania grnego rodkowego 
        // elementu i odjcie 1 w celu uzyskania dolnego rodkowego elementu.
        return ($values[$length / 2] + $values[($length / 2) - 1]) / 2;
    }
}

// Dominanta to warto (lub wartoci), ktre wystpuj w zbiorze najwiksz liczb razy.
// Aby warto moga by dominant, musi wystpowa w zbiorze co najmniej dwa razy.
function array_mode($values) {
    // Funkcja array_count_values zwraca tablic niepowtarzalnych wartoci
    // wraz z licznikiem czstoci ich wystpowania w zbiorze.
    $unique_count = array_count_values($values);

    // Sortowanie wartoci w porzdku malejcym bez sortowania indeksw.
    arsort($unique_count);

    // Przetwarzanie indeksw w ptli, poczwszy od najwyszego, i zliczanie elementw.
    $mode = array();
    $stored_count = 0;
    foreach ($unique_count as $value => $count) {
        // Jeli zmienna $count ma warto 1, wyjcie i koniec oblicze.
        if ($count == 1) { break; }

        // Zapisanie elementu, jeli jeszcze nie obliczono dominanty lub czsto biecego elementu jest rwna 
        // czstoci tych, ktre zapisano wczeniej.
        if ( (count($mode) == 0) || ($count == $stored_count) ) {
            $mode[] = $value;
            $stored_count = $count;
        } else {
            // W innym przypadku znaleziono element o mniejszej czstoci, zatem mona zakoczy obliczenia.
            break;
        }
    }

    // Zwrcenie dominanty. Moe to by pusta tablica, jeli dla zbioru nie istnieje dominanta.
    return $mode;
}

// Deklaracja zbioru liczb i uruchomienie dla nich rnych funkcji.
$set = array(1, 4, 12, 4, 6, 4, 7, 8, 1, 3, 1, 7, 0, 15);

// Wywietlenie wynikw.
echo '<pre>';
echo 'rednia: ', array_mean($set), "\n";
echo 'Zakres : ', array_range($set), "\n";
echo 'Mediana: ', array_median($set), "\n";
echo "Dominanta: \n";
print_r(array_mode($set));
echo '</pre>';
?>
