<?php
// Tablica funkcji konwersji do przeksztacania dowolnych jednostek na kelwiny.
$to_K = array(
    'K' => create_function('$x', 'return $x;'),
    'C' => create_function('$x', 'return $x + 273.15;'),
    'F' => create_function('$x', 'return ($x + 459.67) / 1.8;'),
    'R' => create_function('$x', 'return $x / 1.8;') );

// Tablica funkcji konwersji do przeksztacania kelwinw na dowolne jednostki.
$from_K = array(
    'K' => create_function('$x', 'return $x;'),
    'C' => create_function('$x', 'return $x - 273.15;'),
    'F' => create_function('$x', 'return ($x * 1.8) - 459.67;'),
    'R' => create_function('$x', 'return $x * 1.8;') );
// Funkcja konwersji. Naley przekaza do niej warto oraz jednostki
// rdow i docelow.
function convert_temp($value, $from, $to) {
    global $to_K, $from_K;

    // Sprawdzenie, czy przekazane jednostki s znane. Jeli nie, zwrcenie false.
    if (!(isset($to_K[$from]) && isset($from_K[$to]))) {
        return false;
    } else {
        // Poniewa jednostki waciwie rozpoznano, pozostaje tylko przeksztacenie
        //  wartoci na kelwiny z wykorzystaniem podanej funkcji, a nastpnie ponowne
        //  przeksztacenie na podan jednostk. Operacja wymaga wywoania dwch funkcji.
        return $from_K[$to]($to_K[$from]($value));
    }
}

// Wywietlenie sformatowanej tabeli porwnawczej skali Celsjusza ze skal Fahrenheita:
?>
<style>
td, th { text-align: center; font-size: 20px; }
.extreme { border: 2px solid red; }
.hot { border: 2px solid orange; }
.comfort { border: 2px solid green; }
.cold { border: 2px solid blue; }
.freeze { border: 2px solid navy; }
</style>
<table>
 <tr><th>C</th><th>F</th></tr>
<?php
// Ptla od 50C w d do -10C z postpieniem o 5 stopni.
foreach (range(50, -10, 5) as $c) {
    // Konwersja  temperatury.
    $f = convert_temp($c, 'C', 'F');

    // Wyznaczenie stopnia ciepa na podstawie wartoci w skali Farhenheita.
    if ($f > 100) { $heat = 'skrajnie gorco'; }
    elseif ($f > 80) { $heat = 'gorco'; }
    elseif ($f > 55) { $heat = 'komfortowo'; }
    elseif ($f > 32) { $heat = 'zimno'; }
    else { $heat = 'bardzo zimno'; }

    // Wywietlenie wiersza wcznie z formatowaniem.
    echo "<tr><td class=\"{$heat}\">{$c}</td>
<td class=\"{$heat}\">{$f}</td></tr>";
}
?>
</table>
