<?php
// Biblioteka umoliwiajca przeprowadzanie konwersji midzy rnymi jednostkami miary.

// Deklaracja tablicy prefiksw metrycznych. Kada warto jest potg liczby 10.
// Kady prefiks okrela wielokrotno jednostki podstawowej (kilo, mega, giga itp.).
$metric_prefixes = array( 'Y' => 24, 'Z' => 21, 'E' => 18, 'P' => 15,
    'T' => 12, 'G' => 9, 'M' => 6, 'k' => 3, 'h' => 2, 'da' => 1, '' => 0,
    'd' => -1, 'c' => -2, 'm' => -3, '' => -6, 'n' => -9, 'p' => -12,
    'f' => -15, 'a' => -18, 'z' => -21, 'y' => -24 );

// Tablica wspczynnikw konwersji dla innych jednosiek dugoci w relacji do metra.
$length_equiv = array( 'pc' => 3.085678E+16, 'ly' => 9.46073E+15,
    'AU' => 1.495979E+11, 'mi' => 1609.344, 'ch' => 20.11684,
    'rd' => 5.029210, 'yd' => .9144, 'ft' => .3048, 'in' => .0254 );

// Tablica wspczynnikw konwersji dla jednostek masy w relacji do grama.
$mass_equiv = array( 'ton' => 907184.7, 'lb' => .00045359237,
    'oz' => 20.834952, 'gr' => .06479891 );

// Tablica wspczynnikw konwersji dla jednostek objtoci w relacji do litra.
$volume_equiv = array( 'bu' => 35.23907, 'pk' => 8.809768,
    'gal' => 3.785412, 'qt' => .9463529, 'pt' => .4731765,
    'cup' => .2365882, 'oz' => .02957353, 'tbsp' => .01478676,
    'tsp' => .004928922 );

// Jednostki podstawowe dla tych operacji.
$base_units = array( 'length' => 'm', 'mass' => 'g', 'volume' => 'L' );

// Ponisza funkcja jest wewntrzna dla funkcji convert_any().
//  Wykonuje wikszo dziaa  okrela na podstawie przekazanej jednostki,
//  jakiego naley uy wspczynnika konwersji w celu przeksztacenia tej jednostki na jednostk podstawow.
function _determine_factor($unit, $type) {
    global $metric_prefixes, $length_equiv;
    global $mass_equiv, $volume_equiv, $base_units;

    // Okrelenie szczegw jednostki podstawowej,
    // wcznie z dugoci cigu (wyraon liczb ujemn).
    $base = $base_units[$type];
    $l = -1 * strlen($base);

    // Sytuacja, gdy znajdziemy jednostk w odpowiedniej tablicy referencyjnej jednostek.
    if (isset(${"{$type}_equiv"}[$unit])) {
        // Odczytanie wspczynnika z tablicy.
        $factor = ${"{$type}_equiv"}[$unit];
    // Sytuacja, gdy mona stwierdzi, e jest to jednostka metryczna, i rozpozna prefiks.
    } elseif (((substr($unit, $l)) == $base)
                && (isset($metric_prefixes[substr($unit, 0, $l)]))) {
        // Obliczenie penego wspczynnika na podstawie potgi liczby 10.
        $factor = pow(10, $metric_prefixes[substr($unit, 0, $l)]);
    } else {
        // W innym przypadku, gdy jednostka jest nierozpoznana, funkcja zwraca false.
        $factor = false;
    }

    return $factor;
}

// Convert_any to funkcja wykonujca wszytkie moliwe operacje konwersji.
// Naley przekaza do niej warto do konwersji, jednostk rdow
//  i jednostk docelow. Naley rwnie wprowadzi cig opisujcy typ:  'length'  dugo, 'mass' masa 
// i 'volume' objto.
function convert_any($value, $from, $to, $type) {
    // Okrelenie wspczynnika konwersji dla dwch jednostek.
    $from_factor = _determine_factor($from, $type);
    $to_factor = _determine_factor($to, $type);

    // Jeli dowolny z wynikw ma warto false  co oznacza, e jedna z jednostek jest nierozpoznana 
        //  zwracane jest false.
    if (($from_factor === false) || ($to_factor === false)) {
        return false;
    } else {
        // W innym przypadku podzielenie wspczynnika rdowego przez docelowy w celu
        //  uzyskania wspczynnika konwersji dla okrelonej operacji.  Pomnoenie tej wartoci przez warto
        //  bazow i zwrcenie wyniku.
        return $value * ($from_factor / $to_factor);
    }
}

// Ponisze trzy funkcje zaimplementowano dla wygody. atwiej
// posugiwa si oddzielnymi funkcjami, ni przekazywa zmienn konfiguracyjn.
function convert_length($value, $from, $to) {
    return convert_any($value, $from, $to, 'length');
}

function convert_mass($value, $from, $to) {
    return convert_any($value, $from, $to, 'mass');
}

function convert_volume($value, $from, $to) {
    return convert_any($value, $from, $to, 'volume');
}

// Kilka testowych konwersji.
echo "<pre>\n";

// Konwersja 42 cali na metry: 42 in = 1,0668 m.
echo '42 in = ', convert_length(42, 'in', 'm'), " m\n";

// Konwersja 1,5 gigagramw na tony: 1,5 Gg = 1653,467039292 ton
echo '1.5 Gg = ', convert_mass(1.5, 'Gg', 'ton'), " ton\n";

// Konwersja 723 nanolitrw na mililitry: 723 nl = 0,000723 ml
echo '723 nl = ', convert_volume(723, 'nL', 'mL'), " ml\n";

echo '</pre>';
?>
