<?php
ob_start();
require '02r04-1.php';
ob_end_clean();
//  Funkcja generujca harmonogram spat z wykorzystaniem reguy 78 do obliczania odsetek:
// a = kwota pocztkowa, od ktrej naliczamy odsetki,
// r = roczna stopa procentowa,
// y = liczba lat, na jak udzielono poyczki.
function create_payment_table($a, $r, $y) {
    // Obliczenie cakowitej kwoty odsetek i cakowitej kwoty do spaty.
    $interest = calc_simple_interest($a, $r, $y);
    $payment = $a + $interest;

    // Obliczenie wielkoci miesicznej raty.
    $monthly = $payment / ($y * 12);

    // Wywietlenie obliczonych wartoci:
    echo "
czna kwota do zapaty = {$payment}<br />
czna kwota odsetek = {$interest}<br />
Miesiczna rata = {$monthly}<br />
";

    // Obliczenie wspczynnika reguy 78.
    $rule78 = array_sum(range(1, ($y * 12)));

    // Pocztek harmonogramu.
    echo "<style>td { border: 1px solid black; }</style>
<table><tr><th>Miesic</th><th>Odsetki</th><th>Kapita</th>
<th>Spacony kapita</th></tr>\n";

    // Przetwarzanie w ptli wszystkich miesicy od koca do pocztku.
    $equity = 0;
    for ($m = ($y * 12); $m > 0; $m--) {
        // Obliczenie numeru miesica.
        $num = abs($m - ($y * 12) - 1);

        // Obliczenie odsetek, kapitau i kwoty pozostaej do spaty.
        $int = $interest * ($m/$rule78);
        $prin = $monthly - $int;
        $equity += $prin;

        // Wywietlenie obliczonych wartoci.
        echo "<tr><td>{$num}</td><td>{$int}</td><td>{$prin}</td>
<td>{$equity}</td></tr>\n";
    }

    // Zakoczenie tabeli i wyjcie.
    echo '</table>';
}

// Utworzenie harmonogramu dla poyczki w wysokoci  250 000 PLN udzielonej na 15 lat z oprocentowaniem 5.5%.
// Oto pocztkowy fragment wyniku:
// czna kwota do zapaty = 456 250
// czna kwota odsetek = 206 250
// Miesiczna rata = 2534.7222222222
// Miesic     Odsetki          Kapita           Spacony kapita
// 1           2279.0055248619  255.71669736034   255.71669736034
// 2           2266.3443830571  268.37783916513   524.09453652548
create_payment_table(250000, .055, 15);
?>
