<?php
ob_start();
require '02r04-1.php';
ob_end_clean();
// Obliczenie i wywietlenie tabeli wartoci prezentujcej miesiczne saldo
//  karty kredytowej przy zaoeniu, e rozpoczynamy od debetu 5000 PLN i stosujemy oprocentowanie 9.2%.
//  Odsetki s naliczane co miesic, a miesiczna wpata to 200 PLN.
$value = 5000;
$rate = .092;
$payment = 200;

// Pocztek strony:
echo "<style>td { border: 1px solid black; }</style>
<table><tr><th>Miesic</th><th>Kwota pocztkowa</th><th>Odsetki</th>
<th>Spata</th><th>Saldo na koniec miesica</th>
<th>Cakowita kwota spat</th></tr>\n";

// Ptla do momentu, kiedy warto wyniesie 0 lub mniej.
$month = 1;
$cumulative = 0;
while ($value > 0) {
    // Obliczenie odsetek dla biecego miesica.
    $interest = calc_simple_interest($value, $rate, 1/12);

    // Obliczenie nowej kwoty kapitau.
    $newvalue = $value + $interest;

    // Sprawdzenie, czy spata nie bdzie za wysoka i odpowiednie jej dostosowanie.
    $payment = ($payment > $newvalue) ? $newvalue : $payment;

    // Dodanie spaty do cakowitej kwoty spat.
    $cumulative += $payment;

    // Obliczenie kwoty kocowej.
    $finalvalue = $newvalue - $payment;

    // Wywietlenie obliczonych wartoci.
    echo '<tr><td>', $month++, "</td><td>{$value}</td><td>{$interest}</td>
<td>{$payment}</td><td>{$finalvalue}</td><td>{$cumulative}</td></tr>\n";

    // Ustawienie wartoci na kwot do spaty na koniec biecego miesica i powtrzenie oblicze.
    $value = $finalvalue;
}

//  Zakoczenie wyniku i wyjcie ... Wywietli si tabela, z ktrej
//  wynika, e spata debetu zajmie 28 miesicy, a cakowita
//  zapacona kwota wyniesie 5572.15 PLN.
echo '</table>';
?>
