<?php
// Obliczenie odsetek skadanych:
// a = kwota pocztkowa, od ktrej naliczamy odsetki,
// r = roczna stopa procentowa,
// f = czstotliwo naliczania odsetek (w cigu roku),
// y = liczba lat, dla ktrych s wykonywane obliczenia.
function calc_compound_interest($a, $r, $f, $y) {
    return $a * pow((1 + ($r / $f)), ($f * $y));
}

// Obliczenia dla kwoty 5000 PLN i oprocentowania 3.25%,
//  odsetki naliczane codziennie, przez 3 lata.  Odpowied: 5512.0332828079
echo calc_compound_interest(5000, .0325, 365, 3), '<br />';

// Obliczenia dla kwoty 1000 PLN i oprocentowania 8,5%,
//  odsetki naliczane co miesic, przez 6 miesicy. Odpowied: 1043.2597499629
echo calc_compound_interest(1000, .085, 12, .5);
?>
