<?php
// Funkcja pobierajca liczb cakowit i zwracajca rzymsk reprezentacj jej wartoci.
function romanize($num) {
    // Zapewnienie wykorzystania wycznie cakowitej czci liczby.
    $n = intval($num);
    $result = '';

    // Deklaracja tablicy, w ktrej bdziemy wyszukiwa poszczeglne czci liczby:
    $lookup = array('M' => 1000, 'CM' => 900, 'D' => 500, 'CD' => 400,
                    'C' => 100, 'XC' => 90, 'L' => 50, 'XL' => 40,
                    'X' => 10, 'IX' => 9, 'V' => 5, 'IV' => 4, 'I' => 1);

    // Ptla przetwarzajca warto i tworzca cig znakw. W kadym etapie dzielimy
    //  liczb przez warto maksymalnego czonu (cyfry lub grupy), nie wikszego ni warto
    // na tym poziomie, wywietlamy t cz liczby obliczon liczb razy. Zastpujemy warto
    // reszt z dzielenia wartoci przez okrelony czon i powtarzamy operacj.
    foreach ($lookup as $roman => $value) {
        // Wyznaczenie liczby pasujcych cyfr.
        $matches = intval($n / $value);

        // Powtrzenie tej liczby cyfr rzymskich.
        $result .= str_repeat($roman, $matches);

        // Zastpienie wartoci reszt z dzielenia.
        $n = $n % $value;
    }

    // Liczba rzymska jest gotowa. Zwrcenie wyniku.
    return $result;
}

// Przykady konwersji rnych liczb na posta liczb rzymskich:
// 2005 = MMV
// 1999 = MCMXCIX
// 42 = XLII
echo '<pre>';
echo "\n 2005 = ", romanize(2005);
echo "\n 1999 = ", romanize(1999);
echo "\n 42 = ", romanize(42);
echo '</pre>';
?>
