<?php
//Funkcja wykonujca konwersj cigu znakw na liczb niezalenie od zapisu.
function retrieve_number($str) {
    // Najpierw naley odpowiednio przygotowa cig znakw,
    //  zatem usuwamy wszystkie znaki rne od cyfr, kropki oraz znaku -.
    $str = preg_replace('/[^0-9.-]/', '', $str);

    // Teraz mona bezpiecznie wywoa funkcj floatval, ktra dokona konwersji cigu na liczb typu float 
        // i zwrci wynik.
    return floatval($str);
}

// Kilka przykadw:
$test1 = '$123,432.55';
$test2 = '  a  -57.2';

// W przypadku prby bezporedniego uycia cigw jako liczb float ...
// uzyskamy nastpujce wartoci:
// test1 = 0
// test2 = 0
echo '<pre>';
echo "\ntest1 = " . ($test1 * 1.0);
echo "\ntest2 = " . ($test2 * 1.0);

// Natomiast w przypadku skorzystania z naszej funkcji:
// wyniki bd nastpujce:
// test1 = 123432.55
// test2 = -57.2
echo "\ntest1 = " . retrieve_number($test1);
echo "\ntest2 = " . retrieve_number($test2);
echo '</pre>';
?>
