<?php
require_once( 'woo/base/Registry.php' );
require_once( 'woo/base/Exceptions.php' );

abstract class woo_process_Base {
    static $DB;
    static $stmts = array();
   
    function __construct() {
        self::$DB = woo_base_RequestRegistry::getDB( "DB" );
        if ( ! self::$DB ) {
            throw new woo_base_AppException( "Brak obiektu DB" );
        }
        if ( DB::isError( self::$DB ) ) {
            throw new woo_base_DBException( self::$DB );
        }
    } 

    function prepareStatement( $stmt_s ) {
        if ( self::$stmts[$stmt_s] ) {
            return self::$stmts[$stmt_s];
        }
        $stmt_handle = self::$DB->prepare($stmt_s);
        if ( DB::isError( $stmt_handle ) ) {
            throw new woo_base_DBException( $stmt_handle );
        }
        self::$stmts[$stmt_s]=$stmt_handle;
        return $stmt_handle;
    } 

    protected function doStatement( $stmt_s, $values_a ) {
        $sth = $this->prepareStatement( $stmt_s );
        $db_result = self::$DB->execute( $sth, $values_a );
        if ( DB::isError( $db_result ) ) {
            throw new woo_base_DBException( $db_result );
        }
        return $db_result;
    }
}
