<?php
require_once( "woo/mapper.php" ); 
require_once( "woo/domain/Collections.php" ); 
require_once( "woo/mapper/Collection.php" ); 
require_once( "woo/domain/Venue.php" ); 

class woo_mapper_VenueCollection 
        extends woo_mapper_Collection
        implements woo_domain_VenueCollection {

    function add( woo_domain_Venue $venue ) {
        $this->doAdd( $venue );
    }
}

class woo_mapper_SpaceCollection 
        extends woo_mapper_Collection
        implements woo_domain_SpaceCollection {

    function add( woo_domain_Space $space ) {
        $this->doAdd( $space );
    }
}

class woo_mapper_EventCollection 
        extends woo_mapper_Collection
        implements woo_domain_EventCollection {

    function add( woo_domain_Event $event ) {
        $this->doAdd( $event );
    }
}

class woo_mapper_DeferredEventCollection 
        extends woo_mapper_EventCollection {
    private $stmt;
    private $valueArray;
    private $mapper;
    private $run=false;

    function __construct( woo_mapper_Mapper $mapper, $stmt_handle, 
                        $valueArray ) {
        parent::__construct( ); 
        $this->stmt = $stmt_handle;
        $this->valueArray = $valueArray;
        $this->mapper = $mapper;
    }

    function notifyAccess() {
        if ( ! $this->run ) {
            $result = 
                $this->mapper->doStatement( $this->stmt, $this->valueArray );
            $this->init_db( $result, $this->mapper );
        } 
        $this->run=true;
    }
}



?>
