<?php
require_once( 'ShopProduct.php' );

$prod_class = new ReflectionClass( CdProduct );
$method = $prod_class->getMethod( "__construct" );
$params = $method->getParameters();

foreach ( $params as $param ) {
  print argData( $param );
}

function argData( ReflectionParameter $arg ) {
  $details = "";
  $name  = $arg->getName();
  $class = $arg->getClass();

  if ( ! empty( $class )  ) {
    $classname = $class->getName();
    $details .= "\$$name musi by obiektem klasy $classname\n"; 
  }
  if ( $arg->allowsNull() ) {
    $details .= "\$$name moe by pusty\n"; 
  }
  if ( $arg->isPassedByReference() ) {
    $details .= "\$$name jest przekazywany przez referencj\n"; 
  }
  return $details;
}

?>
