<?php
class User{
    private $name;
    function __construct( $name ) {
        $this->name = $name;
    }
}

class ReceiverFactory {
    static function getMessageSystem() {
        return new MessageSystem();
    }
    static function getAccessManager() {
        return new AccessManager();
    }
}

class MessageSystem {
    function send( $mail, $msg, $topic ) {
        return true;
    }

    function getError() {
        return "nie robi zbiegowiska, nie ma tu nic do ogldania";
    }
}

class AccessManager {
    function login( $user, $pass ) {
        $ret = new User( $user );
        return $ret;
    }

    function getError() {
        return "nie robi zbiegowiska, nie ma tu nic do ogldania";
    }
}

class CommandContext {
    private $params = array();
    private $error = "";

    function __construct() {
        $this->params = $_REQUEST;
    }

    function addParam( $key, $val ) { 
        $this->params[$key]=$val;
    }

    function get( $key ) { 
        return $this->params[$key];
    }

    function setError( $error ) {
        $this->error = $error;
    }
    function getError() {
        return $this->error;
    }
}

abstract class Command {
    abstract function execute( CommandContext $context );
}

class FeedbackCommand extends Command {

    function execute( CommandContext $context ) {
        $msgSystem = ReceiverFactory::getMessageSystem();
        $email = $context->get( 'email' );
        $msg = $context->get( 'pass' );
        $topic = $context->get( 'topic' );
        $result = $msgSystem->despatch( $email, $msg, $topic );
        if ( ! $user ) {
            $this->context->setError( $msgSystem->getError() );
            return false;
        }
        $context->addParam( "user", $user );
        return true;
    }
}


class LoginCommand extends Command {

    function execute( CommandContext $context ) {
        $manager = ReceiverFactory::getAccessManager();
        $user = $context->get( 'username' );
        $pass = $context->get( 'pass' );
        $user = $manager->login( $user, $pass );
        if ( ! $user ) {
            $this->context->setError( $manager->getError() );
            return false;
        }
        $context->addParam( "user", $user );
        return true;
    }
}


$context = new CommandContext();
$context->addParam( "username", "bob" );
$context->addParam( "pass", "tiddles" );
$cmd = new LoginCommand( new AccessManager() );
if ( ! $cmd->execute( $context ) ) {
    print "wystpi bd: ".$context->getError();
} else {
    print "udane logowanie\n";
    $user_obj = $context->get( "user" );
}
