<?php
class ShopProduct {
    private $title;
    private $producerMainName;
    private $producerFirstName;
    protected $price;
    private $discount = 0; 
    
    public function __construct(   $title, $firstName, 
                            $mainName, $price ) { 
        $this->title             = $title;
        $this->producerFirstName = $firstName;
        $this->producerMainName  = $mainName;
        $this->price             = $price;
    }

    public function getProducerFirstName() {
        return $this->producerFirstName;
    }

    public function getProducerMainName() {
        return $this->producerMainName;
    }

    public function setDiscount( $num ) {
        $this->discount=$num;
    }

    public function getDiscount() {
        return $this->discount;
    }
    
    public function getTitle() {
        return $this->title;
    }

    public function getPrice() {
        return ($this->price - $this->discount);
    }

    public function getProducer() {
        return "{$this->producerFirstName}".
               " {$this->producerMainName}";
    }

    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        return $base;
    }
}

class CdProduct extends ShopProduct {
    private $playLength = 0;

    public function __construct(   $title, $firstName, 
                            $mainName, $price, $playLength ) { 
        parent::__construct(    $title, $firstName, 
                                $mainName, $price );
        $this->playLength = $playLength;
    }

    public function getPlayLength() {
        return $this->playLength;
    }

    function getSummaryLine() {
        $base = parent::getSummaryLine();
        $base .= ": czas nagrania - $this->playLength";
        return $base;
    }
 
}

class BookProduct extends ShopProduct {
    private $numPages = 0;

    public function __construct(   $title, $firstName, 
                            $mainName, $price, $numPages ) { 
        parent::__construct(    $title, $firstName, 
                                $mainName, $price );
        $this->numPages = $numPages;
    }

    public function getNumberOfPages() {
        return $this->numPages;
    }
   
    function getSummaryLine() {
        $base = parent::getSummaryLine();
        $base .= ": liczba stron - $this->numPages";
        return $base;
    }

    public function getPrice() {
        return $this->price;
    }
}

$product1 = new BookProduct(    "Moja Antonia", "Willa", "Cather", 59.99, 300 );
$product2 =   new CdProduct(    "Exile on Coldharbour Lane", 
                                "The", "Alabama 3", 25.99, 60.33 );
$product1->setDiscount( 1 );
print $product1->getPrice();
print "\n";
$product2->setDiscount( 1 );
print $product2->getPrice();
print "\n";
print "Tytu:              ".$product1->getTitle()."\n";
print "Imi:               ".$product1->getProducerFirstName()."\n";
print "Nazwisko-pseudonim: ".$product1->getProducerMainName()."\n";
print "Autor:              ".$product1->getProducer()."\n";
print "Liczba stron:       ".$product1->getNumberOfPages()."\n";
print "Opis:               ".$product1->getSummaryLine()."\n";

print "Tytu:              ".$product2->getTitle()."\n";
print "Imi:               ".$product2->getProducerFirstName()."\n";
print "Nazwisko-pseudonim: ".$product2->getProducerMainName()."\n";
print "Wykonawca:          ".$product2->getProducer()."\n";
print "Czas nagrania:      ".$product2->getPlayLength()."\n";
print "Opis:               ".$product2->getSummaryLine()."\n";

/*
// Autor:         Willa Cather
// Liczba stron:  300
// Wykonawca:     The Alabama 3
// Czas nagrania: 60.33
*/
?>
