<?php

require_once( "woo/base/Exceptions.php" );
require_once( "woo/mapper.php" );
require_once( "woo/mapper/Mapper.php" );
require_once( "woo/mapper/VenueMapper.php" );
require_once( "woo/mapper/Collections.php" );
require_once( "woo/domain.php" );

class woo_mapper_SpaceMapper extends woo_mapper_Mapper 
                             implements woo_domain_SpaceFinder {

    function __construct() {
        parent::__construct();
        $this->selectAllStmt = self::$DB->prepare( 
                            "SELECT * FROM space");
        $this->selectStmt = self::$DB->prepare( 
                            "SELECT * FROM space WHERE id=?");
        $this->updateStmt = self::$DB->prepare( 
                            "UPDATE space SET name=?, id=? WHERE id=?");
        $this->insertStmt = self::$DB->prepare( 
                            "INSERT into space (name, venue, id) 
                             values( ?, ?, ?)");
        $this->findByVenueStmt = self::$DB->prepare( 
                            "SELECT * FROM space where venue=?");
    } 
    
    function doFind( $id ) {
        $result = $this->doStatement( $this->selectStmt, array( $id ) );
        return $this->load( $result ); 
    }

    function findAll( ) {
        $result = $this->doStatement( $this->selectAllStmt, array() );
        return new woo_mapper_SpaceCollection( $result, $this );
    }

    protected function doLoad( $array ) {
        $obj = new woo_domain_Space( $array['id'] );
        $obj->setname( $array['name'] );
        $ven_mapper = new woo_mapper_VenueMapper();
        $venue = $ven_mapper->find( $array['venue'] );
        $obj->setVenue( $venue );

        $event_mapper = new woo_mapper_EventMapper();
        $event_collection = $event_mapper->findBySpaceId( $array['id'] );        
        $obj->setEvents( $event_collection );
        $obj->markClean();
        return $obj;
    }

    protected function targetClass() {
        return "woo_domain_Space";
    }

    protected function doInsert( woo_domain_DomainObject $object ) {
        $venue = $object->getVenue();
        if ( ! $venue ) { 
            throw new woo_base_AppException( "nie mona zapisa bez placwki" );
        }
        $values = array( $object->getname(), $venue->getId(), $object->getid() ); 
        $this->doStatement( $this->insertStmt, $values );
    }
    
    public function newId() {
        return self::$DB->nextId('space');
    }

    function update( woo_domain_DomainObject $object ) {
        $values = array( $object->getname(), $object->getid(), $object->getId() ); 
        $this->doStatement( $this->updateStmt, $values );
    }

    # wasne
    function findByVenue( $vid ) {
        $result = $this->doStatement( $this->findByVenueStmt, array( $vid ) );
        return new woo_mapper_SpaceCollection( $result, $this );
    }
    # 
}
