<?php
/** 
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @package WebServices
 * @subpackage Authentication
 * @copyright Waferthin Web Works LLC
 * @license http://www.gnu.org/copyleft/gpl.html dostpne na licencji GPL
 */
/** 
 * <i>Authentication</i> zajmuje si kontem uytkownika i logowaniem 
 * 
 * Klasa abstrakcyjna bdca wzrocem dla
 * klas implementujcych uwierzytelnianie
 * z zastosowaniem rnych mechanizmw weryfikacji. 
 *
 * @see Authentication_HardcodedAccounts
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @package WebServices
 * @subpackage Authentication
 * @version 0.5
 * @since r5
 */
abstract class Authentication implements Accountable
{
    /**
     * Referencja do obiektu Account
     * obecnie zalogowanego uytkownika.
     *
     * @access private
     * @var Account
     */
    private $account = null;
    
    /**
     * Zwraca obiekt Account o ile istnieje
     *
     * @see Accountable::getAccount()
     * @access public
     * @param string $user user account login
     * @return Account user account
     */
    public function getAccount($user = '')
    {
        if ($this->account !== null) {
            return $this->account;
        } else {
            return AUTHENTICATION_ERR_MSG;
        }
    }
    
    /**
     * metoda isLoggedIn
     *
     * Informuje, czy biecy uytkownik poda
     * prawidow nazw i haso.
     *
     * @see Accountable::isLoggedIn()
     * @access public
     * @return boolean
     */
    public function isLoggedIn()
    {
        return ($this->account !== null);
    }
    
    /**
     * metoda login
     *
     * Metoda abstrakcyjna, ktra musi zosta
     * zaimplementowana w klasach potomnych tej klasie
     *
     * @access public
     * @return boolean
     */
    abstract public function login($user, $password);
}

?>
