<?php

class ProbeService
{
    // sondowany port
    public $port = 80;

    // sondowany host
    public $host = 'google.com';

    // odwzorowanie numerw portw do typowych odpowiadajcych im nazw usug
    public $serviceName = array(23    => 'telnet',
                                25    => 'smtp',
                                80    => 'http',
                                110 => 'pop3',
                                443    => 'https'
                                );
                                
    // maksymalna liczba sondowa dopuszczalna dla jednego hosta i portu
    protected $maxProbes = null;
    
    // wielowymiarowa tablica przechowujca liczb
    // sondowa na jednego hosta i port
    protected $probeCount = array();
    
    // konstruktor inicjalizuje warto maxProbes na 3
    public function __construct($maxProbes = 3)
    {
        $this->maxProbes = $maxProbes;
    }
    
    // sounduje danego hosta i port
    public function probe($host, $port)
    {
        // zachowuje nazw hosta i port na potrzeby innych metod
        $this->host = $host;
        $this->port = $port;
        
        try {
            
            // pobiera list adresw IP skojarzonyc z hostem
            $ipAddresses = $this->resolveHost();

            // iteruje poprzez wszystkie znalezione adresy IP
            foreach ($ipAddresses as $ip) {
                
                // sprawdza maksymalny limit sondowania
                if ($this->probeCount[$this->host][$this->port] < $this->maxProbes) {

                    // zwiksza warto licznika sondowa biecego hosta i portu
                    $this->increasePortCount();

                    // odnajduje aktywny (odpowiadajcy) port
                    if ($this->tcpConnection()) {

                        echo "$this->host odpowiada na porcie $this->port.";

                        // prbuje wyszuka nazw usugi na podstawie numeru portu
                        if (array_key_exists($this->port, $this->serviceName)) {
                            echo " Port ten jest zwykle przypisany do usugi {$this->serviceName[$this->port]} service.\n";
                        } else {
                            echo " Nie odnaleziono nazwy usugi, ktra moe by przypisana to tego portu.\n";
                        }
                        break;

                    // nie mona nawiza poaczenia
                    } else {
                        echo "Host $this->host nie odpowiada na porcie $this->port.\n";
                    }
                    
                // generuje wyjtek spowodowany przekroczeniem maksymalnej liczby sondowa
                } else {
                    throw new Exception("Limit $this->maxProbes sondowa zosta przekroczony dla hosta $this->host na porcie $this->port.");
                }
            }

        // przechwytuje wyjtki i powiadamia uytkownika
        } catch (Exception $e) {
            exit("Sondowanie nie powiodo si $this->host:$this->port: {$e->getMessage()}");
        }
    }
    
    // wyszukuje adres IP odpowiadajcy danej nazwie hosta
    protected function resolveHost()
    {
        if ($ipAddresses = gethostbynamel($this->host)) {
            return $ipAddresses;
        } else {
            throw new Exception('Nie udao si znale adresu IP dla hosta ' . $this->host . '. Sprawd poczenie sieciowe i poprawno nazwy hosta.');
        }
    }
    
    // metoda ledzca poczenia dla hosta i portu
    protected function increasePortCount()
    {
        // sprawdza, czy dana pozycja ju istnieje
        if (array_key_exists($this->host, $this->probeCount)
            && array_key_exists($this->port, $this->probeCount[$this->host])) {
                
                $this->probeCount[$this->host][$this->port]++;

            // tworzy now pozycj
            } else {
                $this->probeCount[$this->host][$this->port] = 1;
            }
    }
    
    // prbuje nazwiza poczenie poprzez gniazdo
    protected function tcpConnection()
    {
        // prbuje otworzy gniazdo
        $socket = fsockopen($this->host, $this->port, $errorNumber, $errorString, 30);

        // nie udao si otworzy gniazda
        if (!$socket) {
            return FALSE;
        
        // sukces!
        } else {

            // prawidowo zamyka poczenie i zwraca warto true
            fclose($socket);

            return TRUE;
        }
    }
}

$probe = new ProbeService(3);
$probe->probe('yahoo$host, $port.com', 80);

?>