<?php

/**
 * Model_Users
 *
 * Funkcjonalno CRUD i logika kont uytkownika
 * 
 *
 * @package zf_waferthin
 * @author Dirk Merkel
 **/
class Model_Users extends Zend_Db_Table_Abstract
{
    // Nazwa tabeli w bazie danych
    protected $_name = 'users';

    // Klucz gwny tabeli
    protected $_primary = 'id';

    // Przechowuje komunikaty zwrotne
    public $message = array();

    // konstruktor zdefiniowany dla kompletnoci klasy
    public function __construct()
    {
        parent::__construct();
    }
    
    /**
     * Tutaj nastpuje cay proces walidacji.
     * Metoda ta jest uruchamiana przed wstawieniem,
     * dodaniem wpisw lub katalogw przez uytkownika.
     */
    public function validate(Array $data = array())
    {
        $this->message = array();

        // walidacja adresu e-mail
        if (!isset($data['email'])
            || empty($data['email'])
            || !preg_match('/^[a-zA-Z0-9_\.@]{6,}$/', $data['email'])) {

            $this->message[] = 'Wymagany jest adres e-mail, skadajcy si z conajmniej 6 znakw alfanumerycznych.';
        }

        // walidacja formatu hasa
        if (!isset($data['password'])
            || empty($data['password'])
            || !preg_match('/^[a-zA-Z0-9_]{6,}$/', $data['password'])) {

            $this->message[] = 'Wymagane jest haso skadajce si z conajmniej 6 znakw alfanumerycznych.';

        // sprawdza, czy haso zostao poprawnie powtrzone
        } elseif ($data['password'] != $data['password_again']) {
            
            $this->message[] = 'Haso nie zostao poprawnie powtrzone.';
        }
        
        return !count($this->message);
    }
    
    // tworzy nowe konto uytkownika
    public function insert(Array $data = array())
    {
        // wywouje metod insert udostpnian przez klas Zend_Db_Table_Abstract
        $data['password'] = sha1($data['password']);
        return parent::insert($data);
    }
    
    // sprawdza dane uwierzytelniajce
    public function login($email, $password)
    {
        // minimalistyczna walidacja wprowadzonych danych
        if (empty($email) || empty($password)) {
            return false;
        }

        // pobiera obiekt Zend_Db_Table_Select w celu wysania zapytania
        $select = $this->select();
        
        // konstruuje zapytanie
        $select->where('email = ?', $email)
               ->where('password = ?', sha1($password))
               ->where('active = ?', 1)
               ->where('deleted = ?', 0);

        // czy jest jaki rezultat
        $row = $this->fetchRow($select);
        if (!empty($row)) {
            return $row;
        } else {
            return false;
        }
    }
}