<?php
/** 
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @package WebServices
 * @subpackage Authentication
 * @copyright Waferthin Web Works LLC
 * @license http://www.gnu.org/copyleft/gpl.html dostpne na licencji GPL
 */
/** 
 * Klasa <i>Authentication_HardcodedAccounts</i>
 * 
 * Klasa ta implementuje metod login, ktrej zadaniem
 * jest praktyczna obsuga uwierzytelniania uytkownika.
 * Klasa ta jest potomkiem klasy <i>Authentication</i>,
 * i implementacj interfejsu <i>Accountable</i>.
 *
 * @package WebServices
 * @subpackage Authentication
 * @see Authentication
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @version 0.6
 * @since r14
 */
class Authentication_HardcodedAccounts extends Authentication
{
    /**
     * Referencja do obiektu <i>Users</i>
     * @access private
     * @var Users
     */
    private $users;

    /**
     * Authentication_HardcodedAccounts constructor
     *
     * Tworzy egzemplarz obiektu {@link Users} i zachowuje
     * referencj we waciwoci {@link users}.
     *
     * @see Users
     * @access public
     * @return void
     */
    public function __construct()
    {
        $this->users = new Users();
    }
    
    /**
     * metoda login
     *
     * Poprzez klas {@link Users} realizuj
     * weryfikacj uytkownika.
     *
     * @see Users
     * @todo Ustali, ktr z dwch metod walidacji wybra
     * @access public
     * @param string $user account user name
     * @param string $password account password
     * @return boolean
     */
    public function login($user, $password)
    {
        if (empty($user) || empty($password)) {
            return false;
        } else {

            // obydwie metody walidacji powinny dziaa ...

            // metoda statyczna
            $firstValidation = Users::validate($user, $password);

            // metoda "magiczna" validate<nazwa_uytkownika>($password)
            $userLoginFunction = 'validate' . $user;
            $secondValidation = $this->users->$userLoginFunction($password);

            return ($firstValidation && $secondValidation);
        }
    }
}

?>
