<?php
    define("WIDTH", 320);
    define("HEIGHT", 150);
    define("F_SIZE", 20);
    define("F_ANGLE", 20);
    define("F_FONT", "myfont.ttf");
    define("F_TEXT", "PHP 5 Ksiega eksperta");
    
    $img = imagecreate(WIDTH, HEIGHT);
    
    $white = imagecolorallocate($img, 255,255,255);
    $black = imagecolorallocate($img, 0,0,0);
    imagerectangle($img, 0,0,WIDTH-1,HEIGHT-1, $black);
    
    $box = imagettfbbox(F_SIZE, F_ANGLE, F_FONT, F_TEXT);
    
    $start_x = (WIDTH/2) - (int)(($box[0] + $box[2] + $box[4] + $box[6])/4);
    $start_y = (HEIGHT/2) - (int)(($box[1] + $box[3] + $box[5] + $box[7])/4);    

    $polygon = array($box[0]+$start_x,
                     $box[1]+$start_y,
                     $box[2]+$start_x,
                     $box[3]+$start_y,
                     $box[4]+$start_x,
                     $box[5]+$start_y,
                     $box[6]+$start_x,
                     $box[7]+$start_y);
    
    imagepolygon($img, $polygon, 4, $black);
    imageTTFtext($img, F_SIZE, F_ANGLE, $start_x, $start_y, $black, F_FONT, F_TEXT);

    header("Content-Type: image/png");
    imagepng($img);

?>
