<?php

class MySQLiSession {
    const USERNAME = "user";
    const PASSWORD = "secret";
    const HOST = "localhost";
    const DATABASE = "unleashed";
    const TABLE = "session_data";
    const SESS_NAME = "UNLEASHED";
    const SESS_EXPIRE = 3600; /* sekundy */

    private $link;
    private $name;
    private $table;

    function __construct($user = null, $pass = null,
                         $host = null, $db = null,
                         $table = null, $sess_name = null)
    {
        $user = (is_null($user)) ? self::USERNAME : $user;
        $pass = (is_null($pass)) ? self::PASSWORD : $pass;
        $host = (is_null($host)) ? self::HOST : $host;
        $db = (is_null($db)) ? self::DATABASE : $db;
        $this->table = (is_null($table)) ? self::TABLE : $table;
        $this->name = (is_null($sess_name)) ? self::SESS_NAME : $sess_name;

        $this->link = mysqli_connect($host, $user, $pass, $db);

        if(!$this->link) {
            throw new Exception("Nie mona nawiza poczenia z baz danych!");
            return;
        }

        mysqli_select_db($this->link, $db);

        session_set_save_handler(array($this, "handler_open"),
                                 array($this, "handler_close"),
                                 array($this, "handler_read"),
                                 array($this, "handler_write"),
                                 array($this, "handler_destroy"),
                                 array($this, "handler_garbage"));

        session_name($this->name);
        session_start();

    }

    /* Dalsza cz kodu zostaa celowo pominita! */
} 
 
?>