<?php

class reader {
   
    public $path = "/tmp/";
    private $current_handle;
    private $handles = array();
   
    public function clear() {
        @unlink($this->path.$this->handles[$this->current_handle]);
        unset($this->handles[$this->current_handle]);
        readline_clear_history();
    }
   
    public function read($prompt) {   
        $str = readline($prompt);
        readline_add_history($str);
        return $str;
    }
   
    public function set_history($handle) {
   
        if(!isset($this->handles[$handle])) {
            $uniqfile = uniqid("rh_");
            $this->handles[$handle] = $uniqfile;
        }

        if((count(readline_list_history()) == 0)) {

            if(file_exists($this->path.$this->handles[$handle])) {
                if(!readline_read_history($this->path .
                $this->handles[$handle])) {
                    trigger_error("Nie mona zaadowa pliku historii" .
                    " dla ID '$handle'", E_USER_WARNING);
                    return false;
                }
            }

        } else {
            if(!readline_write_history($this->path .
            $this->handles[$this->current_handle]))
            {
                trigger_error("Nie mona zapisa pliku historii dla ID '".
                $this->current_handle."'", E_USER_WARNING);
                return false;
            }

            readline_clear_history();

            if(isset($this->handles[$handle]) &&
            file_exists($this->path.$this->handles[$handle])) {
                if(!readline_read_history($this->path .
                $this->handles[$handle])) {
                    trigger_error("Nie mona zaadowa pliku historii dla ID '" .
                    $handle."'", E_USER_WARNING);
                    return false;
                }
            }
        }

        $this->current_handle = $handle;
        return true;
    }
   
}

?>