<?php 
    
class ShoppingCart {
    
    private $cart;

    function __construct() {
      $this->cart = array();
    }

    public function addItem($id, $name, $cost) {
      foreach($this->cart as $key => $items) {
        if($items['id'] == $id) {
          $this->cart[$key]['quantity']++;
          return;
        }
      }

      $this->cart[] = array('id' => $id,
                            'name' => $name,
                            'cost' => $cost,
                            'quantity' => 1);
    }

    public function delItem($id) {
      foreach($this->cart as $key => $items) {
        if($items['id'] == $id) {
          if ($items['quantity'] > 1) {
            $this->cart[$key]['quantity']--;
          } else {
            unset($this->cart[$key]);
          }
          return true;
        }
      }
      return false;
    }

    public function getCart() {
      return $this->cart;
    }

    public function clearCart() {
      $this->cart = array();
    }

}
?>