<?php

    function sqlite_udf_add($op1, $op2) {
        return $op1 + $op2;
    }

    $sqlite = sqlite_open(":memory:");
    sqlite_query($sqlite, "CREATE TABLE test(" .
                          "value_one INTEGER PRIMARY KEY, " .
                          "value_two INTEGER)");

    for($count = 0; $count <= 10; $count += 2) {
        sqlite_unbuffered_query($sqlite, "INSERT INTO test VALUES(NULL, $count)");
    }

    if(!sqlite_create_function($sqlite, 'my_add', 'sqlite_udf_add', 2)) {
        trigger_error("Could not register custom SQLite UDF 'my add'");
    }

    $result_arr = sqlite_array_query($sqlite,
                                     "SELECT MY_ADD(value_one, value_two) " .
                                     "AS sum " .
                                     "FROM test",
                                     SQLITE_ASSOC);
    
    var_dump($result_arr);

?>