<?xml version="1.0" encoding="ISO-8859-2"?>
 <xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Jest to przykadowy arkusz stylu XSLT przeksztacajcy prosty plik XML na plik
     HTML odpowiedni do wywietlenia w przegldarce WWW. Pamitaj, e
     gwnym wzem jest <xsl:stylesheet> oraz prawidowo zostay zdefiniowane:
     wersja i atrybuty xmlns. -->

    <xsl:template match="/">
     <!-- Ten szablon pasuje tylko do korzenia pliku wejciowego XML -->

        <html>
           <head>
                <title>Przykad XSLT: Naturalne zasoby lasw</title>
           </head>
           <body>

              <!-- Teraz stosujemy szablon dla wszystkich potomkw -->
                <xsl:apply-templates />

           </body>
        </html>

    </xsl:template>

    <xsl:template match="nation">

        <h1>Lasy pastwowe w <i>
            <xsl:value-of select="name" /> </i> </h1>
        <b><xsl:value-of select="name" /> Populacja: </b>
        <xsl:value-of select="population" /> <br/>
        <b><xsl:value-of select="name" /> Rozmiar: </b>
        <xsl:value-of select="size" /> <br/>

        <xsl:apply-templates select="forest" />

    </xsl:template>

    <xsl:template match="forest">

        <h2>Las pastwowy
            <i><xsl:value-of select="name" /></i> </h2>
        <b>Size: </b> <xsl:value-of select="size" /> <br/>

        <xsl:apply-templates select="naturalfeatures" />

    </xsl:template>

    <xsl:template match="naturalfeatures">

        <b>Drzewa: </b> <xsl:apply-templates select="tree" /> <br/>
        <b>Rzeki: </b> <xsl:apply-templates select="river" /> <br/>
        <b>Gry: </b> <xsl:apply-templates select="mountain" /> <br/>

    </xsl:template>

    <xsl:template match="tree|river|mountain">
    <!-- Ten szablon pasuje do elementw <tree>, <river> oraz <mountain>;
         wywietla zawarto elementu, po ktrym znajduje si przecinek, jeeli
         element nie jest ostatnim potomkiem -->

        <xsl:value-of select="." />
        <xsl:if test="position()!=last()">, </xsl:if>

    </xsl:template>

</xsl:stylesheet>